@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.SecuritySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class containing security settings of vault
 * @property immutabilitySettings Immutability Settings at vault level
 * @property softDeleteSettings Soft delete related settings
 */
public data class SecuritySettingsArgs(
    public val immutabilitySettings: Output<ImmutabilitySettingsArgs>? = null,
    public val softDeleteSettings: Output<SoftDeleteSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.SecuritySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.SecuritySettingsArgs =
        com.pulumi.azurenative.dataprotection.inputs.SecuritySettingsArgs.builder()
            .immutabilitySettings(
                immutabilitySettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .softDeleteSettings(
                softDeleteSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SecuritySettingsArgs].
 */
@PulumiTagMarker
public class SecuritySettingsArgsBuilder internal constructor() {
    private var immutabilitySettings: Output<ImmutabilitySettingsArgs>? = null

    private var softDeleteSettings: Output<SoftDeleteSettingsArgs>? = null

    /**
     * @param value Immutability Settings at vault level
     */
    @JvmName("jsxffvadhaijehtt")
    public suspend fun immutabilitySettings(`value`: Output<ImmutabilitySettingsArgs>) {
        this.immutabilitySettings = value
    }

    /**
     * @param value Soft delete related settings
     */
    @JvmName("ivtpkdomqhvanjev")
    public suspend fun softDeleteSettings(`value`: Output<SoftDeleteSettingsArgs>) {
        this.softDeleteSettings = value
    }

    /**
     * @param value Immutability Settings at vault level
     */
    @JvmName("amvbbknaupgkdndl")
    public suspend fun immutabilitySettings(`value`: ImmutabilitySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immutabilitySettings = mapped
    }

    /**
     * @param argument Immutability Settings at vault level
     */
    @JvmName("gmnfwidqayfovygl")
    public suspend
    fun immutabilitySettings(argument: suspend ImmutabilitySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ImmutabilitySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.immutabilitySettings = mapped
    }

    /**
     * @param value Soft delete related settings
     */
    @JvmName("glajhljeukplvxlj")
    public suspend fun softDeleteSettings(`value`: SoftDeleteSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeleteSettings = mapped
    }

    /**
     * @param argument Soft delete related settings
     */
    @JvmName("ffuasuausqosteso")
    public suspend
    fun softDeleteSettings(argument: suspend SoftDeleteSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SoftDeleteSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.softDeleteSettings = mapped
    }

    internal fun build(): SecuritySettingsArgs = SecuritySettingsArgs(
        immutabilitySettings = immutabilitySettings,
        softDeleteSettings = softDeleteSettings,
    )
}
