@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.TaggingCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Tagging criteria
 * @property criteria Criteria which decides whether the tag can be applied to a triggered backup.
 * @property isDefault Specifies if tag is default.
 * @property tagInfo Retention tag information
 * @property taggingPriority Retention Tag priority.
 */
public data class TaggingCriteriaArgs(
    public val criteria: Output<List<ScheduleBasedBackupCriteriaArgs>>? = null,
    public val isDefault: Output<Boolean>,
    public val tagInfo: Output<RetentionTagArgs>,
    public val taggingPriority: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.TaggingCriteriaArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.TaggingCriteriaArgs =
        com.pulumi.azurenative.dataprotection.inputs.TaggingCriteriaArgs.builder()
            .criteria(
                criteria?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .isDefault(isDefault.applyValue({ args0 -> args0 }))
            .tagInfo(tagInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .taggingPriority(taggingPriority.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaggingCriteriaArgs].
 */
@PulumiTagMarker
public class TaggingCriteriaArgsBuilder internal constructor() {
    private var criteria: Output<List<ScheduleBasedBackupCriteriaArgs>>? = null

    private var isDefault: Output<Boolean>? = null

    private var tagInfo: Output<RetentionTagArgs>? = null

    private var taggingPriority: Output<Double>? = null

    /**
     * @param value Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("njtoqipwlnpklxxn")
    public suspend fun criteria(`value`: Output<List<ScheduleBasedBackupCriteriaArgs>>) {
        this.criteria = value
    }

    @JvmName("msuaflvasxqtrtaq")
    public suspend fun criteria(vararg values: Output<ScheduleBasedBackupCriteriaArgs>) {
        this.criteria = Output.all(values.asList())
    }

    /**
     * @param values Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("iuccwvhfiqtccwob")
    public suspend fun criteria(values: List<Output<ScheduleBasedBackupCriteriaArgs>>) {
        this.criteria = Output.all(values)
    }

    /**
     * @param value Specifies if tag is default.
     */
    @JvmName("qunqpiomtvrsrgbu")
    public suspend fun isDefault(`value`: Output<Boolean>) {
        this.isDefault = value
    }

    /**
     * @param value Retention tag information
     */
    @JvmName("rrvkakxhufsitvab")
    public suspend fun tagInfo(`value`: Output<RetentionTagArgs>) {
        this.tagInfo = value
    }

    /**
     * @param value Retention Tag priority.
     */
    @JvmName("pwjnnslfgecwptls")
    public suspend fun taggingPriority(`value`: Output<Double>) {
        this.taggingPriority = value
    }

    /**
     * @param value Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("wbbomhucmwnxfoid")
    public suspend fun criteria(`value`: List<ScheduleBasedBackupCriteriaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.criteria = mapped
    }

    /**
     * @param argument Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("uibgfhppugfjkyvq")
    public suspend
    fun criteria(argument: List<suspend ScheduleBasedBackupCriteriaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScheduleBasedBackupCriteriaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.criteria = mapped
    }

    /**
     * @param argument Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("xfejqfhkklggqbba")
    public suspend fun criteria(
        vararg
        argument: suspend ScheduleBasedBackupCriteriaArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ScheduleBasedBackupCriteriaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.criteria = mapped
    }

    /**
     * @param argument Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("ytwhrqbbmjqphbhe")
    public suspend fun criteria(argument: suspend ScheduleBasedBackupCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScheduleBasedBackupCriteriaArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.criteria = mapped
    }

    /**
     * @param values Criteria which decides whether the tag can be applied to a triggered backup.
     */
    @JvmName("pqucrrbwlrfjssoe")
    public suspend fun criteria(vararg values: ScheduleBasedBackupCriteriaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.criteria = mapped
    }

    /**
     * @param value Specifies if tag is default.
     */
    @JvmName("qyuuttpaemdiskve")
    public suspend fun isDefault(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isDefault = mapped
    }

    /**
     * @param value Retention tag information
     */
    @JvmName("bbtbmrpsnrijslgj")
    public suspend fun tagInfo(`value`: RetentionTagArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagInfo = mapped
    }

    /**
     * @param argument Retention tag information
     */
    @JvmName("gfocpbovnixycmey")
    public suspend fun tagInfo(argument: suspend RetentionTagArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionTagArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tagInfo = mapped
    }

    /**
     * @param value Retention Tag priority.
     */
    @JvmName("sxggyuputiqwcunj")
    public suspend fun taggingPriority(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taggingPriority = mapped
    }

    internal fun build(): TaggingCriteriaArgs = TaggingCriteriaArgs(
        criteria = criteria,
        isDefault = isDefault ?: throw PulumiNullFieldException("isDefault"),
        tagInfo = tagInfo ?: throw PulumiNullFieldException("tagInfo"),
        taggingPriority = taggingPriority ?: throw PulumiNullFieldException("taggingPriority"),
    )
}
