@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.TargetCopySettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Target copy settings
 * @property copyAfter It can be CustomCopyOption or ImmediateCopyOption.
 * @property dataStore Info of target datastore
 */
public data class TargetCopySettingArgs(
    public val copyAfter: Output<Any>,
    public val dataStore: Output<DataStoreInfoBaseArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.TargetCopySettingArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.TargetCopySettingArgs =
        com.pulumi.azurenative.dataprotection.inputs.TargetCopySettingArgs.builder()
            .copyAfter(copyAfter.applyValue({ args0 -> args0 }))
            .dataStore(dataStore.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TargetCopySettingArgs].
 */
@PulumiTagMarker
public class TargetCopySettingArgsBuilder internal constructor() {
    private var copyAfter: Output<Any>? = null

    private var dataStore: Output<DataStoreInfoBaseArgs>? = null

    /**
     * @param value It can be CustomCopyOption or ImmediateCopyOption.
     */
    @JvmName("lathegfxvxidcjtp")
    public suspend fun copyAfter(`value`: Output<Any>) {
        this.copyAfter = value
    }

    /**
     * @param value Info of target datastore
     */
    @JvmName("omxvaijdywtcxbqg")
    public suspend fun dataStore(`value`: Output<DataStoreInfoBaseArgs>) {
        this.dataStore = value
    }

    /**
     * @param value It can be CustomCopyOption or ImmediateCopyOption.
     */
    @JvmName("gmfdipnujolbrbtk")
    public suspend fun copyAfter(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.copyAfter = mapped
    }

    /**
     * @param value Info of target datastore
     */
    @JvmName("clcrmleeviutrlnb")
    public suspend fun dataStore(`value`: DataStoreInfoBaseArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStore = mapped
    }

    /**
     * @param argument Info of target datastore
     */
    @JvmName("duhvypqclkktodco")
    public suspend fun dataStore(argument: suspend DataStoreInfoBaseArgsBuilder.() -> Unit) {
        val toBeMapped = DataStoreInfoBaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataStore = mapped
    }

    internal fun build(): TargetCopySettingArgs = TargetCopySettingArgs(
        copyAfter = copyAfter ?: throw PulumiNullFieldException("copyAfter"),
        dataStore = dataStore ?: throw PulumiNullFieldException("dataStore"),
    )
}
