@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Duration based custom options to copy
 * @property duration Data copied after given timespan
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'CustomCopyOption'.
 */
public data class CustomCopyOptionResponse(
    public val duration: String? = null,
    public val objectType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.CustomCopyOptionResponse):
            CustomCopyOptionResponse = CustomCopyOptionResponse(
            duration = javaType.duration().map({ args0 -> args0 }).orElse(null),
            objectType = javaType.objectType(),
        )
    }
}
