@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * DataStoreInfo base
 * @property dataStoreType type of datastore; Operational/Vault/Archive
 * @property objectType Type of Datasource object, used to initialize the right inherited type
 */
public data class DataStoreInfoBaseResponse(
    public val dataStoreType: String,
    public val objectType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.DataStoreInfoBaseResponse):
            DataStoreInfoBaseResponse = DataStoreInfoBaseResponse(
            dataStoreType = javaType.dataStoreType(),
            objectType = javaType.objectType(),
        )
    }
}
