@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Backup Vault Resource
 * @property eTag Optional ETag.
 * @property id Resource Id represents the complete path to the resource.
 * @property identity Input Managed Identity Details
 * @property location Resource location.
 * @property name Resource name associated with the resource.
 * @property properties BackupVaultResource properties
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
 */
public data class GetBackupVaultResult(
    public val eTag: String? = null,
    public val id: String,
    public val identity: DppIdentityDetailsResponse? = null,
    public val location: String,
    public val name: String,
    public val properties: BackupVaultResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.GetBackupVaultResult):
            GetBackupVaultResult = GetBackupVaultResult(
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.DppIdentityDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.BackupVaultResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
