@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Inner Error
 * @property additionalInfo Any Key value pairs that can be provided to the client for additional  verbose information.
 * @property code Unique code for this error
 * @property embeddedInnerError Child Inner Error, to allow Nesting.
 */
public data class InnerErrorResponse(
    public val additionalInfo: Map<String, String>? = null,
    public val code: String? = null,
    public val embeddedInnerError: InnerErrorResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.InnerErrorResponse):
            InnerErrorResponse = InnerErrorResponse(
            additionalInfo = javaType.additionalInfo().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            embeddedInnerError = javaType.embeddedInnerError().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.InnerErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
