@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * This class contains all the details about a critical operation.
 * @property requestResourceType Type of resource request.
 * @property vaultCriticalOperation Name of the critical operation.
 */
public data class ResourceGuardOperationResponse(
    public val requestResourceType: String,
    public val vaultCriticalOperation: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.ResourceGuardOperationResponse):
            ResourceGuardOperationResponse = ResourceGuardOperationResponse(
            requestResourceType = javaType.requestResourceType(),
            vaultCriticalOperation = javaType.vaultCriticalOperation(),
        )
    }
}
