@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Schedule based trigger context
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'ScheduleBasedTriggerContext'.
 * @property schedule Schedule for this backup
 * @property taggingCriteria List of tags that can be applicable for given schedule.
 */
public data class ScheduleBasedTriggerContextResponse(
    public val objectType: String,
    public val schedule: BackupScheduleResponse,
    public val taggingCriteria: List<TaggingCriteriaResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.ScheduleBasedTriggerContextResponse):
            ScheduleBasedTriggerContextResponse = ScheduleBasedTriggerContextResponse(
            objectType = javaType.objectType(),
            schedule = javaType.schedule().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.BackupScheduleResponse.Companion.toKotlin(args0)
            }),
            taggingCriteria = javaType.taggingCriteria().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.TaggingCriteriaResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
