@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress
import kotlin.collections.List

/**
 * Tagging criteria
 * @property criteria Criteria which decides whether the tag can be applied to a triggered backup.
 * @property isDefault Specifies if tag is default.
 * @property tagInfo Retention tag information
 * @property taggingPriority Retention Tag priority.
 */
public data class TaggingCriteriaResponse(
    public val criteria: List<ScheduleBasedBackupCriteriaResponse>? = null,
    public val isDefault: Boolean,
    public val tagInfo: RetentionTagResponse,
    public val taggingPriority: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.TaggingCriteriaResponse):
            TaggingCriteriaResponse = TaggingCriteriaResponse(
            criteria = javaType.criteria().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.ScheduleBasedBackupCriteriaResponse.Companion.toKotlin(args0)
                })
            }),
            isDefault = javaType.isDefault(),
            tagInfo = javaType.tagInfo().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.RetentionTagResponse.Companion.toKotlin(args0)
            }),
            taggingPriority = javaType.taggingPriority(),
        )
    }
}
