@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.GetProtectedItemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property protectedItemName The protected item name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vaultName The vault name.
 */
public data class GetProtectedItemPlainArgs(
    public val protectedItemName: String,
    public val resourceGroupName: String,
    public val vaultName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.GetProtectedItemPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.inputs.GetProtectedItemPlainArgs =
        com.pulumi.azurenative.datareplication.inputs.GetProtectedItemPlainArgs.builder()
            .protectedItemName(protectedItemName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProtectedItemPlainArgs].
 */
@PulumiTagMarker
public class GetProtectedItemPlainArgsBuilder internal constructor() {
    private var protectedItemName: String? = null

    private var resourceGroupName: String? = null

    private var vaultName: String? = null

    /**
     * @param value The protected item name.
     */
    @JvmName("rwfdvoctxduvrihd")
    public suspend fun protectedItemName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.protectedItemName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xbrvrcxuvooajngb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The vault name.
     */
    @JvmName("pcsyvjoorhqbbekb")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetProtectedItemPlainArgs = GetProtectedItemPlainArgs(
        protectedItemName = protectedItemName ?: throw PulumiNullFieldException("protectedItemName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
