@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.HyperVMigrateFabricModelCustomPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * HyperV migrate fabric model custom properties.
 * @property hyperVSiteId Gets or sets the ARM Id of the HyperV site.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'HyperVMigrate'.
 * @property migrationSolutionId Gets or sets the migration solution ARM Id.
 */
public data class HyperVMigrateFabricModelCustomPropertiesArgs(
    public val hyperVSiteId: Output<String>,
    public val instanceType: Output<String>,
    public val migrationSolutionId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.HyperVMigrateFabricModelCustomPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.HyperVMigrateFabricModelCustomPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.HyperVMigrateFabricModelCustomPropertiesArgs.builder()
            .hyperVSiteId(hyperVSiteId.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .migrationSolutionId(migrationSolutionId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HyperVMigrateFabricModelCustomPropertiesArgs].
 */
@PulumiTagMarker
public class HyperVMigrateFabricModelCustomPropertiesArgsBuilder internal constructor() {
    private var hyperVSiteId: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var migrationSolutionId: Output<String>? = null

    /**
     * @param value Gets or sets the ARM Id of the HyperV site.
     */
    @JvmName("isjbqcujxgcoeawe")
    public suspend fun hyperVSiteId(`value`: Output<String>) {
        this.hyperVSiteId = value
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'HyperVMigrate'.
     */
    @JvmName("bhdvosmbugnkawgp")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Gets or sets the migration solution ARM Id.
     */
    @JvmName("owtufsdypjuidwky")
    public suspend fun migrationSolutionId(`value`: Output<String>) {
        this.migrationSolutionId = value
    }

    /**
     * @param value Gets or sets the ARM Id of the HyperV site.
     */
    @JvmName("ettgphtkaqnylebw")
    public suspend fun hyperVSiteId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVSiteId = mapped
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'HyperVMigrate'.
     */
    @JvmName("utjlxesrorpgqnlq")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Gets or sets the migration solution ARM Id.
     */
    @JvmName("cxioprdwclrjwyts")
    public suspend fun migrationSolutionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationSolutionId = mapped
    }

    internal fun build(): HyperVMigrateFabricModelCustomPropertiesArgs =
        HyperVMigrateFabricModelCustomPropertiesArgs(
            hyperVSiteId = hyperVSiteId ?: throw PulumiNullFieldException("hyperVSiteId"),
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            migrationSolutionId = migrationSolutionId ?: throw PulumiNullFieldException("migrationSolutionId"),
        )
}
