@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.VMwareMigrateFabricModelCustomPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VMware migrate fabric model custom properties.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'VMwareMigrate'.
 * @property migrationSolutionId Gets or sets the ARM Id of the migration solution.
 * @property vmwareSiteId Gets or sets the ARM Id of the VMware site.
 */
public data class VMwareMigrateFabricModelCustomPropertiesArgs(
    public val instanceType: Output<String>,
    public val migrationSolutionId: Output<String>,
    public val vmwareSiteId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.VMwareMigrateFabricModelCustomPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.VMwareMigrateFabricModelCustomPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.VMwareMigrateFabricModelCustomPropertiesArgs.builder()
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .migrationSolutionId(migrationSolutionId.applyValue({ args0 -> args0 }))
            .vmwareSiteId(vmwareSiteId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VMwareMigrateFabricModelCustomPropertiesArgs].
 */
@PulumiTagMarker
public class VMwareMigrateFabricModelCustomPropertiesArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var migrationSolutionId: Output<String>? = null

    private var vmwareSiteId: Output<String>? = null

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'VMwareMigrate'.
     */
    @JvmName("jdpkihetgdwvaddq")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Gets or sets the ARM Id of the migration solution.
     */
    @JvmName("ursiqhdvpgxxqgdb")
    public suspend fun migrationSolutionId(`value`: Output<String>) {
        this.migrationSolutionId = value
    }

    /**
     * @param value Gets or sets the ARM Id of the VMware site.
     */
    @JvmName("mlhyvqmbiqoivwub")
    public suspend fun vmwareSiteId(`value`: Output<String>) {
        this.vmwareSiteId = value
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'VMwareMigrate'.
     */
    @JvmName("nthnboipjudgsait")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the migration solution.
     */
    @JvmName("nmjljsvouvgluvbv")
    public suspend fun migrationSolutionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationSolutionId = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the VMware site.
     */
    @JvmName("hymhrayhetthoqun")
    public suspend fun vmwareSiteId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmwareSiteId = mapped
    }

    internal fun build(): VMwareMigrateFabricModelCustomPropertiesArgs =
        VMwareMigrateFabricModelCustomPropertiesArgs(
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            migrationSolutionId = migrationSolutionId ?: throw PulumiNullFieldException("migrationSolutionId"),
            vmwareSiteId = vmwareSiteId ?: throw PulumiNullFieldException("vmwareSiteId"),
        )
}
