@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VMware to AzStackHCI Replication extension model custom properties.
 * @property azStackHciFabricArmId Gets or sets the ARM Id of the target AzStackHCI fabric.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'VMwareToAzStackHCI'.
 * @property storageAccountId Gets or sets the storage account Id.
 * @property storageAccountSasSecretName Gets or sets the Sas Secret of storage account.
 * @property vmwareFabricArmId Gets or sets the ARM Id of the source VMware fabric.
 */
public data class VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs(
    public val azStackHciFabricArmId: Output<String>,
    public val instanceType: Output<String>,
    public val storageAccountId: Output<String>? = null,
    public val storageAccountSasSecretName: Output<String>? = null,
    public val vmwareFabricArmId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs.builder()
            .azStackHciFabricArmId(azStackHciFabricArmId.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .storageAccountSasSecretName(storageAccountSasSecretName?.applyValue({ args0 -> args0 }))
            .vmwareFabricArmId(vmwareFabricArmId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs].
 */
@PulumiTagMarker
public class VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgsBuilder internal
constructor() {
    private var azStackHciFabricArmId: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var storageAccountId: Output<String>? = null

    private var storageAccountSasSecretName: Output<String>? = null

    private var vmwareFabricArmId: Output<String>? = null

    /**
     * @param value Gets or sets the ARM Id of the target AzStackHCI fabric.
     */
    @JvmName("sqxlufhyqaviqfyp")
    public suspend fun azStackHciFabricArmId(`value`: Output<String>) {
        this.azStackHciFabricArmId = value
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'VMwareToAzStackHCI'.
     */
    @JvmName("xeoluclyaunatxxm")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Gets or sets the storage account Id.
     */
    @JvmName("tivunmjuldfnircf")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value Gets or sets the Sas Secret of storage account.
     */
    @JvmName("tblfjidvxgoxmkkt")
    public suspend fun storageAccountSasSecretName(`value`: Output<String>) {
        this.storageAccountSasSecretName = value
    }

    /**
     * @param value Gets or sets the ARM Id of the source VMware fabric.
     */
    @JvmName("nhdtyluwbmbyqgig")
    public suspend fun vmwareFabricArmId(`value`: Output<String>) {
        this.vmwareFabricArmId = value
    }

    /**
     * @param value Gets or sets the ARM Id of the target AzStackHCI fabric.
     */
    @JvmName("jaswjfimywlgspwh")
    public suspend fun azStackHciFabricArmId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azStackHciFabricArmId = mapped
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'VMwareToAzStackHCI'.
     */
    @JvmName("bwtosjgtsqubqvjk")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Gets or sets the storage account Id.
     */
    @JvmName("medpruocpxydusxh")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value Gets or sets the Sas Secret of storage account.
     */
    @JvmName("ubyfbweogyqxiogp")
    public suspend fun storageAccountSasSecretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountSasSecretName = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the source VMware fabric.
     */
    @JvmName("xutyqwdfehdcxeid")
    public suspend fun vmwareFabricArmId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmwareFabricArmId = mapped
    }

    internal fun build(): VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs =
        VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs(
            azStackHciFabricArmId = azStackHciFabricArmId ?: throw
                PulumiNullFieldException("azStackHciFabricArmId"),
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            storageAccountId = storageAccountId,
            storageAccountSasSecretName = storageAccountSasSecretName,
            vmwareFabricArmId = vmwareFabricArmId ?: throw PulumiNullFieldException("vmwareFabricArmId"),
        )
}
