@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.VaultModelPropertiesArgs.builder
import com.pulumi.azurenative.datareplication.kotlin.enums.ReplicationVaultType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Vault properties.
 * @property vaultType Gets or sets the type of vault.
 */
public data class VaultModelPropertiesArgs(
    public val vaultType: Output<Either<String, ReplicationVaultType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.VaultModelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.inputs.VaultModelPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.VaultModelPropertiesArgs.builder()
            .vaultType(
                vaultType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VaultModelPropertiesArgs].
 */
@PulumiTagMarker
public class VaultModelPropertiesArgsBuilder internal constructor() {
    private var vaultType: Output<Either<String, ReplicationVaultType>>? = null

    /**
     * @param value Gets or sets the type of vault.
     */
    @JvmName("fwfvksloilmnuxfe")
    public suspend fun vaultType(`value`: Output<Either<String, ReplicationVaultType>>) {
        this.vaultType = value
    }

    /**
     * @param value Gets or sets the type of vault.
     */
    @JvmName("ulausomyhnmtsegk")
    public suspend fun vaultType(`value`: Either<String, ReplicationVaultType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultType = mapped
    }

    /**
     * @param value Gets or sets the type of vault.
     */
    @JvmName("nuiwstydypqfxhrt")
    public fun vaultType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReplicationVaultType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultType = mapped
    }

    /**
     * @param value Gets or sets the type of vault.
     */
    @JvmName("jhdxdjwrulxshnit")
    public fun vaultType(`value`: ReplicationVaultType) {
        val toBeMapped = Either.ofRight<String, ReplicationVaultType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultType = mapped
    }

    internal fun build(): VaultModelPropertiesArgs = VaultModelPropertiesArgs(
        vaultType = vaultType,
    )
}
