@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Health error model.
 * @property affectedResourceCorrelationIds Gets or sets the list of affected resource correlation Ids. This can be used to
 * uniquely identify the count of items affected by a specific category and severity
 * as well as count of item affected by an specific issue.
 * @property affectedResourceType Gets or sets the type of affected resource type.
 * @property category Gets or sets the error category.
 * @property causes Gets or sets possible causes of the error.
 * @property childErrors Gets or sets a list of child health errors associated with this error.
 * @property code Gets or sets the error code.
 * @property creationTime Gets or sets the error creation time.
 * @property healthCategory Gets or sets the health category.
 * @property isCustomerResolvable Gets or sets a value indicating whether the error is customer resolvable.
 * @property message Gets or sets the error message.
 * @property recommendation Gets or sets recommended action to resolve the error.
 * @property severity Gets or sets the error severity.
 * @property source Gets or sets the error source.
 * @property summary Gets or sets the error summary.
 */
public data class HealthErrorModelResponse(
    public val affectedResourceCorrelationIds: List<String>? = null,
    public val affectedResourceType: String? = null,
    public val category: String,
    public val causes: String,
    public val childErrors: List<InnerHealthErrorModelResponse>? = null,
    public val code: String,
    public val creationTime: String,
    public val healthCategory: String,
    public val isCustomerResolvable: Boolean,
    public val message: String,
    public val recommendation: String,
    public val severity: String,
    public val source: String,
    public val summary: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.HealthErrorModelResponse):
            HealthErrorModelResponse = HealthErrorModelResponse(
            affectedResourceCorrelationIds = javaType.affectedResourceCorrelationIds().map({ args0 -> args0 }),
            affectedResourceType = javaType.affectedResourceType().map({ args0 -> args0 }).orElse(null),
            category = javaType.category(),
            causes = javaType.causes(),
            childErrors = javaType.childErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datareplication.kotlin.outputs.InnerHealthErrorModelResponse.Companion.toKotlin(args0)
                })
            }),
            code = javaType.code(),
            creationTime = javaType.creationTime(),
            healthCategory = javaType.healthCategory(),
            isCustomerResolvable = javaType.isCustomerResolvable(),
            message = javaType.message(),
            recommendation = javaType.recommendation(),
            severity = javaType.severity(),
            source = javaType.source(),
            summary = javaType.summary(),
        )
    }
}
