@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VMware DRA model custom properties.
 * @property biosId Gets or sets the BIOS Id of the DRA machine.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'VMware'.
 * @property marsAuthenticationIdentity Identity model.
 */
public data class VMwareDraModelCustomPropertiesResponse(
    public val biosId: String,
    public val instanceType: String,
    public val marsAuthenticationIdentity: IdentityModelResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.VMwareDraModelCustomPropertiesResponse):
            VMwareDraModelCustomPropertiesResponse = VMwareDraModelCustomPropertiesResponse(
            biosId = javaType.biosId(),
            instanceType = javaType.instanceType(),
            marsAuthenticationIdentity = javaType.marsAuthenticationIdentity().let({ args0 ->
                com.pulumi.azurenative.datareplication.kotlin.outputs.IdentityModelResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
