@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VMware to AzStackHCI Replication extension model custom properties.
 * @property asrServiceUri Gets or sets the Uri of ASR.
 * @property azStackHciFabricArmId Gets or sets the ARM Id of the target AzStackHCI fabric.
 * @property azStackHciSiteId Gets or sets the ARM Id of the AzStackHCI site.
 * @property gatewayServiceUri Gets or sets the Uri of Gateway.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'VMwareToAzStackHCI'.
 * @property rcmServiceUri Gets or sets the Uri of Rcm.
 * @property resourceGroup Gets or sets the resource group.
 * @property resourceLocation Gets or sets the resource location.
 * @property sourceGatewayServiceId Gets or sets the gateway service Id of source.
 * @property sourceStorageContainerName Gets or sets the source storage container name.
 * @property storageAccountId Gets or sets the storage account Id.
 * @property storageAccountSasSecretName Gets or sets the Sas Secret of storage account.
 * @property subscriptionId Gets or sets the subscription.
 * @property targetGatewayServiceId Gets or sets the gateway service Id of target.
 * @property targetStorageContainerName Gets or sets the target storage container name.
 * @property vmwareFabricArmId Gets or sets the ARM Id of the source VMware fabric.
 * @property vmwareSiteId Gets or sets the ARM Id of the VMware site.
 */
public data class VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesResponse(
    public val asrServiceUri: String,
    public val azStackHciFabricArmId: String,
    public val azStackHciSiteId: String,
    public val gatewayServiceUri: String,
    public val instanceType: String,
    public val rcmServiceUri: String,
    public val resourceGroup: String,
    public val resourceLocation: String,
    public val sourceGatewayServiceId: String,
    public val sourceStorageContainerName: String,
    public val storageAccountId: String? = null,
    public val storageAccountSasSecretName: String? = null,
    public val subscriptionId: String,
    public val targetGatewayServiceId: String,
    public val targetStorageContainerName: String,
    public val vmwareFabricArmId: String,
    public val vmwareSiteId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesResponse):
            VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesResponse =
            VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesResponse(
                asrServiceUri = javaType.asrServiceUri(),
                azStackHciFabricArmId = javaType.azStackHciFabricArmId(),
                azStackHciSiteId = javaType.azStackHciSiteId(),
                gatewayServiceUri = javaType.gatewayServiceUri(),
                instanceType = javaType.instanceType(),
                rcmServiceUri = javaType.rcmServiceUri(),
                resourceGroup = javaType.resourceGroup(),
                resourceLocation = javaType.resourceLocation(),
                sourceGatewayServiceId = javaType.sourceGatewayServiceId(),
                sourceStorageContainerName = javaType.sourceStorageContainerName(),
                storageAccountId = javaType.storageAccountId().map({ args0 -> args0 }).orElse(null),
                storageAccountSasSecretName = javaType.storageAccountSasSecretName().map({ args0 ->
                    args0
                }).orElse(null),
                subscriptionId = javaType.subscriptionId(),
                targetGatewayServiceId = javaType.targetGatewayServiceId(),
                targetStorageContainerName = javaType.targetStorageContainerName(),
                vmwareFabricArmId = javaType.vmwareFabricArmId(),
                vmwareSiteId = javaType.vmwareSiteId(),
            )
    }
}
