@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.AccountArgs.builder
import com.pulumi.azurenative.datashare.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.datashare.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An account data transfer object.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### Accounts_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.DataShare.Account("account", new()
 *     {
 *         AccountName = "Account1",
 *         Identity = new AzureNative.DataShare.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.DataShare.Type.SystemAssigned,
 *         },
 *         Location = "West US 2",
 *         ResourceGroupName = "SampleResourceGroup",
 *         Tags =
 *         {
 *             { "tag1", "Red" },
 *             { "tag2", "White" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewAccount(ctx, "account", &datashare.AccountArgs{
 * 			AccountName: pulumi.String("Account1"),
 * 			Identity: &datashare.IdentityArgs{
 * 				Type: pulumi.String(datashare.TypeSystemAssigned),
 * 			},
 * 			Location:          pulumi.String("West US 2"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("Red"),
 * 				"tag2": pulumi.String("White"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.Account;
 * import com.pulumi.azurenative.datashare.AccountArgs;
 * import com.pulumi.azurenative.datashare.inputs.IdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("Account1")
 *             .identity(IdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("West US 2")
 *             .resourceGroupName("SampleResourceGroup")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "Red"),
 *                 Map.entry("tag2", "White")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:Account Account1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}
 * ```
 * @property accountName The name of the share account.
 * @property identity Identity Info on the Account
 * @property location Location of the azure resource.
 * @property resourceGroupName The resource group name.
 * @property tags Tags on the azure resource.
 */
public data class AccountArgs(
    public val accountName: Output<String>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.AccountArgs =
        com.pulumi.azurenative.datashare.AccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("fqvkbmsgeieywsnu")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Identity Info on the Account
     */
    @JvmName("vuugprxsrrakohof")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Location of the azure resource.
     */
    @JvmName("dbdtqjrbvxjvypex")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qqahxsqawejbflhy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags on the azure resource.
     */
    @JvmName("mqcowcbsfgfdnokt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("jjdvwxdnhmjguwca")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Identity Info on the Account
     */
    @JvmName("ewwvyolpbbpjqufm")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity Info on the Account
     */
    @JvmName("ycvsdskwhrardqwd")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Location of the azure resource.
     */
    @JvmName("rrgceiyapolxmjpw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("dhisyhavussrssdw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags on the azure resource.
     */
    @JvmName("ymfjmnjmohcplqys")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags on the azure resource.
     */
    @JvmName("fyxlbagfnpinyutq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountName = accountName,
        identity = identity,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
