@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BlobDataSet].
 */
@PulumiTagMarker
public class BlobDataSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BlobDataSetArgs = BlobDataSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BlobDataSetArgsBuilder.() -> Unit) {
        val builder = BlobDataSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BlobDataSet {
        val builtJavaResource = com.pulumi.azurenative.datashare.BlobDataSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BlobDataSet(builtJavaResource)
    }
}

/**
 * An Azure storage blob data set.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSets_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         ContainerName = "C1",
 *         DataSetName = "Dataset1",
 *         FilePath = "file21",
 *         Kind = "Blob",
 *         ResourceGroup = "SampleResourceGroup",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *         StorageAccountName = "storage2",
 *         SubscriptionId = "433a8dfd-e5d5-4e77-ad86-90acdc75eb1a",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:        pulumi.String("Account1"),
 * 			ContainerName:      pulumi.String("C1"),
 * 			DataSetName:        pulumi.String("Dataset1"),
 * 			FilePath:           pulumi.String("file21"),
 * 			Kind:               pulumi.String("Blob"),
 * 			ResourceGroup:      pulumi.String("SampleResourceGroup"),
 * 			ResourceGroupName:  pulumi.String("SampleResourceGroup"),
 * 			ShareName:          pulumi.String("Share1"),
 * 			StorageAccountName: pulumi.String("storage2"),
 * 			SubscriptionId:     pulumi.String("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("Account1")
 *             .containerName("C1")
 *             .dataSetName("Dataset1")
 *             .filePath("file21")
 *             .kind("Blob")
 *             .resourceGroup("SampleResourceGroup")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .storageAccountName("storage2")
 *             .subscriptionId("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoCluster_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoDatabase_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDBTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDWTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSet = new AzureNative.DataShare.BlobDataSet("blobDataSet", new()
 *     {
 *         AccountName = "sourceAccount",
 *         DataSetName = "dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSet(ctx, "blobDataSet", &datashare.BlobDataSetArgs{
 * 			AccountName:       pulumi.String("sourceAccount"),
 * 			DataSetName:       pulumi.String("dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSet;
 * import com.pulumi.azurenative.datashare.BlobDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSet = new BlobDataSet("blobDataSet", BlobDataSetArgs.builder()
 *             .accountName("sourceAccount")
 *             .dataSetName("dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("share1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:BlobDataSet dataset1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/dataSets/{dataSetName}
 * ```
 */
public class BlobDataSet internal constructor(
    override val javaResource: com.pulumi.azurenative.datashare.BlobDataSet,
) : KotlinCustomResource(javaResource, BlobDataSetMapper) {
    /**
     * Container that has the file path.
     */
    public val containerName: Output<String>
        get() = javaResource.containerName().applyValue({ args0 -> args0 })

    /**
     * Unique id for identifying a data set resource
     */
    public val dataSetId: Output<String>
        get() = javaResource.dataSetId().applyValue({ args0 -> args0 })

    /**
     * File path within the source data set
     */
    public val filePath: Output<String>
        get() = javaResource.filePath().applyValue({ args0 -> args0 })

    /**
     * Kind of data set.
     * Expected value is 'Blob'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Name of the azure resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource group of storage account
     */
    public val resourceGroup: Output<String>
        get() = javaResource.resourceGroup().applyValue({ args0 -> args0 })

    /**
     * Storage account name of the source data set
     */
    public val storageAccountName: Output<String>
        get() = javaResource.storageAccountName().applyValue({ args0 -> args0 })

    /**
     * Subscription id of storage account
     */
    public val subscriptionId: Output<String>
        get() = javaResource.subscriptionId().applyValue({ args0 -> args0 })

    /**
     * System Data of the Azure resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Type of the azure resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BlobDataSetMapper : ResourceMapper<BlobDataSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datashare.BlobDataSet::class == javaResource::class

    override fun map(javaResource: Resource): BlobDataSet = BlobDataSet(
        javaResource as
            com.pulumi.azurenative.datashare.BlobDataSet,
    )
}

/**
 * @see [BlobDataSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BlobDataSet].
 */
public suspend fun blobDataSet(name: String, block: suspend BlobDataSetResourceBuilder.() -> Unit):
    BlobDataSet {
    val builder = BlobDataSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BlobDataSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun blobDataSet(name: String): BlobDataSet {
    val builder = BlobDataSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
