@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BlobDataSetMapping].
 */
@PulumiTagMarker
public class BlobDataSetMappingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BlobDataSetMappingArgs = BlobDataSetMappingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BlobDataSetMappingArgsBuilder.() -> Unit) {
        val builder = BlobDataSetMappingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BlobDataSetMapping {
        val builtJavaResource =
            com.pulumi.azurenative.datashare.BlobDataSetMapping(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BlobDataSetMapping(builtJavaResource)
    }
}

/**
 * A Blob data set mapping.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSetMappings_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSetMapping = new AzureNative.DataShare.BlobDataSetMapping("blobDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         ContainerName = "C1",
 *         DataSetId = "a08f184b-0567-4b11-ba22-a1199336d226",
 *         DataSetMappingName = "DatasetMapping1",
 *         FilePath = "file21",
 *         Kind = "Blob",
 *         ResourceGroup = "SampleResourceGroup",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *         StorageAccountName = "storage2",
 *         SubscriptionId = "433a8dfd-e5d5-4e77-ad86-90acdc75eb1a",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSetMapping(ctx, "blobDataSetMapping", &datashare.BlobDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			ContainerName:         pulumi.String("C1"),
 * 			DataSetId:             pulumi.String("a08f184b-0567-4b11-ba22-a1199336d226"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			FilePath:              pulumi.String("file21"),
 * 			Kind:                  pulumi.String("Blob"),
 * 			ResourceGroup:         pulumi.String("SampleResourceGroup"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 			StorageAccountName:    pulumi.String("storage2"),
 * 			SubscriptionId:        pulumi.String("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSetMapping;
 * import com.pulumi.azurenative.datashare.BlobDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSetMapping = new BlobDataSetMapping("blobDataSetMapping", BlobDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .containerName("C1")
 *             .dataSetId("a08f184b-0567-4b11-ba22-a1199336d226")
 *             .dataSetMappingName("DatasetMapping1")
 *             .filePath("file21")
 *             .kind("Blob")
 *             .resourceGroup("SampleResourceGroup")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .storageAccountName("storage2")
 *             .subscriptionId("433a8dfd-e5d5-4e77-ad86-90acdc75eb1a")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDB_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSetMapping = new AzureNative.DataShare.BlobDataSetMapping("blobDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSetMapping(ctx, "blobDataSetMapping", &datashare.BlobDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSetMapping;
 * import com.pulumi.azurenative.datashare.BlobDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSetMapping = new BlobDataSetMapping("blobDataSetMapping", BlobDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDWDataSetToAdlsGen2File_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSetMapping = new AzureNative.DataShare.BlobDataSetMapping("blobDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSetMapping(ctx, "blobDataSetMapping", &datashare.BlobDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSetMapping;
 * import com.pulumi.azurenative.datashare.BlobDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSetMapping = new BlobDataSetMapping("blobDataSetMapping", BlobDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDW_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSetMapping = new AzureNative.DataShare.BlobDataSetMapping("blobDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSetMapping(ctx, "blobDataSetMapping", &datashare.BlobDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSetMapping;
 * import com.pulumi.azurenative.datashare.BlobDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSetMapping = new BlobDataSetMapping("blobDataSetMapping", BlobDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobDataSetMapping = new AzureNative.DataShare.BlobDataSetMapping("blobDataSetMapping", new()
 *     {
 *         AccountName = "consumerAccount",
 *         DataSetMappingName = "datasetMappingName1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobDataSetMapping(ctx, "blobDataSetMapping", &datashare.BlobDataSetMappingArgs{
 * 			AccountName:           pulumi.String("consumerAccount"),
 * 			DataSetMappingName:    pulumi.String("datasetMappingName1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobDataSetMapping;
 * import com.pulumi.azurenative.datashare.BlobDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobDataSetMapping = new BlobDataSetMapping("blobDataSetMapping", BlobDataSetMappingArgs.builder()
 *             .accountName("consumerAccount")
 *             .dataSetMappingName("datasetMappingName1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:BlobDataSetMapping datasetMappingName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/dataSetMappings/{dataSetMappingName}
 * ```
 */
public class BlobDataSetMapping internal constructor(
    override val javaResource: com.pulumi.azurenative.datashare.BlobDataSetMapping,
) : KotlinCustomResource(javaResource, BlobDataSetMappingMapper) {
    /**
     * Container that has the file path.
     */
    public val containerName: Output<String>
        get() = javaResource.containerName().applyValue({ args0 -> args0 })

    /**
     * The id of the source data set.
     */
    public val dataSetId: Output<String>
        get() = javaResource.dataSetId().applyValue({ args0 -> args0 })

    /**
     * Gets the status of the data set mapping.
     */
    public val dataSetMappingStatus: Output<String>
        get() = javaResource.dataSetMappingStatus().applyValue({ args0 -> args0 })

    /**
     * File path within the source data set
     */
    public val filePath: Output<String>
        get() = javaResource.filePath().applyValue({ args0 -> args0 })

    /**
     * Kind of data set mapping.
     * Expected value is 'Blob'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Name of the azure resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * File output type
     */
    public val outputType: Output<String>?
        get() = javaResource.outputType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the data set mapping.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource group of storage account.
     */
    public val resourceGroup: Output<String>
        get() = javaResource.resourceGroup().applyValue({ args0 -> args0 })

    /**
     * Storage account name of the source data set.
     */
    public val storageAccountName: Output<String>
        get() = javaResource.storageAccountName().applyValue({ args0 -> args0 })

    /**
     * Subscription id of storage account.
     */
    public val subscriptionId: Output<String>
        get() = javaResource.subscriptionId().applyValue({ args0 -> args0 })

    /**
     * System Data of the Azure resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Type of the azure resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BlobDataSetMappingMapper : ResourceMapper<BlobDataSetMapping> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datashare.BlobDataSetMapping::class == javaResource::class

    override fun map(javaResource: Resource): BlobDataSetMapping = BlobDataSetMapping(
        javaResource as
            com.pulumi.azurenative.datashare.BlobDataSetMapping,
    )
}

/**
 * @see [BlobDataSetMapping].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BlobDataSetMapping].
 */
public suspend fun blobDataSetMapping(
    name: String,
    block: suspend BlobDataSetMappingResourceBuilder.() -> Unit,
): BlobDataSetMapping {
    val builder = BlobDataSetMappingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BlobDataSetMapping].
 * @param name The _unique_ name of the resulting resource.
 */
public fun blobDataSetMapping(name: String): BlobDataSetMapping {
    val builder = BlobDataSetMappingResourceBuilder()
    builder.name(name)
    return builder.build()
}
