@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ScheduledSynchronizationSetting].
 */
@PulumiTagMarker
public class ScheduledSynchronizationSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduledSynchronizationSettingArgs = ScheduledSynchronizationSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduledSynchronizationSettingArgsBuilder.() -> Unit) {
        val builder = ScheduledSynchronizationSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ScheduledSynchronizationSetting {
        val builtJavaResource =
            com.pulumi.azurenative.datashare.ScheduledSynchronizationSetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ScheduledSynchronizationSetting(builtJavaResource)
    }
}

/**
 * A type of synchronization setting based on schedule
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### SynchronizationSettings_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledSynchronizationSetting = new AzureNative.DataShare.ScheduledSynchronizationSetting("scheduledSynchronizationSetting", new()
 *     {
 *         AccountName = "Account1",
 *         Kind = "ScheduleBased",
 *         RecurrenceInterval = AzureNative.DataShare.RecurrenceInterval.Day,
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *         SynchronizationSettingName = "Dataset1",
 *         SynchronizationTime = "2018-11-14T04:47:52.9614956Z",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewScheduledSynchronizationSetting(ctx, "scheduledSynchronizationSetting", &datashare.ScheduledSynchronizationSettingArgs{
 * 			AccountName:                pulumi.String("Account1"),
 * 			Kind:                       pulumi.String("ScheduleBased"),
 * 			RecurrenceInterval:         pulumi.String(datashare.RecurrenceIntervalDay),
 * 			ResourceGroupName:          pulumi.String("SampleResourceGroup"),
 * 			ShareName:                  pulumi.String("Share1"),
 * 			SynchronizationSettingName: pulumi.String("Dataset1"),
 * 			SynchronizationTime:        pulumi.String("2018-11-14T04:47:52.9614956Z"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ScheduledSynchronizationSetting;
 * import com.pulumi.azurenative.datashare.ScheduledSynchronizationSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledSynchronizationSetting = new ScheduledSynchronizationSetting("scheduledSynchronizationSetting", ScheduledSynchronizationSettingArgs.builder()
 *             .accountName("Account1")
 *             .kind("ScheduleBased")
 *             .recurrenceInterval("Day")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .synchronizationSettingName("Dataset1")
 *             .synchronizationTime("2018-11-14T04:47:52.9614956Z")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:ScheduledSynchronizationSetting SynchronizationSetting1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/synchronizationSettings/{synchronizationSettingName}
 * ```
 */
public class ScheduledSynchronizationSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.datashare.ScheduledSynchronizationSetting,
) : KotlinCustomResource(javaResource, ScheduledSynchronizationSettingMapper) {
    /**
     * Time at which the synchronization setting was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Kind of synchronization setting.
     * Expected value is 'ScheduleBased'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Name of the azure resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the provisioning state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Recurrence Interval
     */
    public val recurrenceInterval: Output<String>
        get() = javaResource.recurrenceInterval().applyValue({ args0 -> args0 })

    /**
     * Synchronization time
     */
    public val synchronizationTime: Output<String>
        get() = javaResource.synchronizationTime().applyValue({ args0 -> args0 })

    /**
     * System Data of the Azure resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Type of the azure resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Name of the user who created the synchronization setting.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object ScheduledSynchronizationSettingMapper :
    ResourceMapper<ScheduledSynchronizationSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datashare.ScheduledSynchronizationSetting::class == javaResource::class

    override fun map(javaResource: Resource): ScheduledSynchronizationSetting =
        ScheduledSynchronizationSetting(
            javaResource as
                com.pulumi.azurenative.datashare.ScheduledSynchronizationSetting,
        )
}

/**
 * @see [ScheduledSynchronizationSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScheduledSynchronizationSetting].
 */
public suspend fun scheduledSynchronizationSetting(
    name: String,
    block: suspend ScheduledSynchronizationSettingResourceBuilder.() -> Unit,
):
    ScheduledSynchronizationSetting {
    val builder = ScheduledSynchronizationSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScheduledSynchronizationSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scheduledSynchronizationSetting(name: String): ScheduledSynchronizationSetting {
    val builder = ScheduledSynchronizationSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
