@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ShareSubscription].
 */
@PulumiTagMarker
public class ShareSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ShareSubscriptionArgs = ShareSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ShareSubscriptionArgsBuilder.() -> Unit) {
        val builder = ShareSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ShareSubscription {
        val builtJavaResource =
            com.pulumi.azurenative.datashare.ShareSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ShareSubscription(builtJavaResource)
    }
}

/**
 * A share subscription data transfer object.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2018-11-01-preview.
 * ## Example Usage
 * ### ShareSubscriptions_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var shareSubscription = new AzureNative.DataShare.ShareSubscription("shareSubscription", new()
 *     {
 *         AccountName = "Account1",
 *         ExpirationDate = "2020-08-26T22:33:24.5785265Z",
 *         InvitationId = "12345678-1234-1234-12345678abd",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *         SourceShareLocation = "eastus2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewShareSubscription(ctx, "shareSubscription", &datashare.ShareSubscriptionArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			ExpirationDate:        pulumi.String("2020-08-26T22:33:24.5785265Z"),
 * 			InvitationId:          pulumi.String("12345678-1234-1234-12345678abd"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 			SourceShareLocation:   pulumi.String("eastus2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.ShareSubscription;
 * import com.pulumi.azurenative.datashare.ShareSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var shareSubscription = new ShareSubscription("shareSubscription", ShareSubscriptionArgs.builder()
 *             .accountName("Account1")
 *             .expirationDate("2020-08-26T22:33:24.5785265Z")
 *             .invitationId("12345678-1234-1234-12345678abd")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .sourceShareLocation("eastus2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:ShareSubscription ShareSubscription1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}
 * ```
 */
public class ShareSubscription internal constructor(
    override val javaResource: com.pulumi.azurenative.datashare.ShareSubscription,
) : KotlinCustomResource(javaResource, ShareSubscriptionMapper) {
    /**
     * Time at which the share subscription was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The expiration date of the share subscription.
     */
    public val expirationDate: Output<String>?
        get() = javaResource.expirationDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The invitation id.
     */
    public val invitationId: Output<String>
        get() = javaResource.invitationId().applyValue({ args0 -> args0 })

    /**
     * Name of the azure resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Email of the provider who created the resource
     */
    public val providerEmail: Output<String>
        get() = javaResource.providerEmail().applyValue({ args0 -> args0 })

    /**
     * Name of the provider who created the resource
     */
    public val providerName: Output<String>
        get() = javaResource.providerName().applyValue({ args0 -> args0 })

    /**
     * Tenant name of the provider who created the resource
     */
    public val providerTenantName: Output<String>
        get() = javaResource.providerTenantName().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the share subscription
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Description of share
     */
    public val shareDescription: Output<String>
        get() = javaResource.shareDescription().applyValue({ args0 -> args0 })

    /**
     * Kind of share
     */
    public val shareKind: Output<String>
        get() = javaResource.shareKind().applyValue({ args0 -> args0 })

    /**
     * Name of the share
     */
    public val shareName: Output<String>
        get() = javaResource.shareName().applyValue({ args0 -> args0 })

    /**
     * Gets the current status of share subscription.
     */
    public val shareSubscriptionStatus: Output<String>
        get() = javaResource.shareSubscriptionStatus().applyValue({ args0 -> args0 })

    /**
     * Terms of a share
     */
    public val shareTerms: Output<String>
        get() = javaResource.shareTerms().applyValue({ args0 -> args0 })

    /**
     * Source share location.
     */
    public val sourceShareLocation: Output<String>
        get() = javaResource.sourceShareLocation().applyValue({ args0 -> args0 })

    /**
     * System Data of the Azure resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Type of the azure resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Email of the user who created the resource
     */
    public val userEmail: Output<String>
        get() = javaResource.userEmail().applyValue({ args0 -> args0 })

    /**
     * Name of the user who created the resource
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object ShareSubscriptionMapper : ResourceMapper<ShareSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datashare.ShareSubscription::class == javaResource::class

    override fun map(javaResource: Resource): ShareSubscription = ShareSubscription(
        javaResource as
            com.pulumi.azurenative.datashare.ShareSubscription,
    )
}

/**
 * @see [ShareSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ShareSubscription].
 */
public suspend fun shareSubscription(
    name: String,
    block: suspend ShareSubscriptionResourceBuilder.() -> Unit,
): ShareSubscription {
    val builder = ShareSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ShareSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun shareSubscription(name: String): ShareSubscription {
    val builder = ShareSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
