@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SqlDBTableDataSetMapping].
 */
@PulumiTagMarker
public class SqlDBTableDataSetMappingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlDBTableDataSetMappingArgs = SqlDBTableDataSetMappingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlDBTableDataSetMappingArgsBuilder.() -> Unit) {
        val builder = SqlDBTableDataSetMappingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlDBTableDataSetMapping {
        val builtJavaResource =
            com.pulumi.azurenative.datashare.SqlDBTableDataSetMapping(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlDBTableDataSetMapping(builtJavaResource)
    }
}

/**
 * A SQL DB Table data set mapping.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSetMappings_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDBTableDataSetMapping = new AzureNative.DataShare.SqlDBTableDataSetMapping("sqlDBTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDBTableDataSetMapping(ctx, "sqlDBTableDataSetMapping", &datashare.SqlDBTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDBTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SqlDBTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDBTableDataSetMapping = new SqlDBTableDataSetMapping("sqlDBTableDataSetMapping", SqlDBTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDB_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDBTableDataSetMapping = new AzureNative.DataShare.SqlDBTableDataSetMapping("sqlDBTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetId = "a08f184b-0567-4b11-ba22-a1199336d226",
 *         DataSetMappingName = "DatasetMapping1",
 *         DatabaseName = "Database1",
 *         Kind = "SqlDBTable",
 *         ResourceGroupName = "SampleResourceGroup",
 *         SchemaName = "dbo",
 *         ShareSubscriptionName = "ShareSubscription1",
 *         SqlServerResourceId = "/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Sql/servers/Server1",
 *         TableName = "Table1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDBTableDataSetMapping(ctx, "sqlDBTableDataSetMapping", &datashare.SqlDBTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetId:             pulumi.String("a08f184b-0567-4b11-ba22-a1199336d226"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			DatabaseName:          pulumi.String("Database1"),
 * 			Kind:                  pulumi.String("SqlDBTable"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			SchemaName:            pulumi.String("dbo"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 			SqlServerResourceId:   pulumi.String("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Sql/servers/Server1"),
 * 			TableName:             pulumi.String("Table1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDBTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SqlDBTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDBTableDataSetMapping = new SqlDBTableDataSetMapping("sqlDBTableDataSetMapping", SqlDBTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetId("a08f184b-0567-4b11-ba22-a1199336d226")
 *             .dataSetMappingName("DatasetMapping1")
 *             .databaseName("Database1")
 *             .kind("SqlDBTable")
 *             .resourceGroupName("SampleResourceGroup")
 *             .schemaName("dbo")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .sqlServerResourceId("/subscriptions/433a8dfd-e5d5-4e77-ad86-90acdc75eb1a/resourceGroups/SampleResourceGroup/providers/Microsoft.Sql/servers/Server1")
 *             .tableName("Table1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDWDataSetToAdlsGen2File_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDBTableDataSetMapping = new AzureNative.DataShare.SqlDBTableDataSetMapping("sqlDBTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDBTableDataSetMapping(ctx, "sqlDBTableDataSetMapping", &datashare.SqlDBTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDBTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SqlDBTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDBTableDataSetMapping = new SqlDBTableDataSetMapping("sqlDBTableDataSetMapping", SqlDBTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDW_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDBTableDataSetMapping = new AzureNative.DataShare.SqlDBTableDataSetMapping("sqlDBTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDBTableDataSetMapping(ctx, "sqlDBTableDataSetMapping", &datashare.SqlDBTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDBTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SqlDBTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDBTableDataSetMapping = new SqlDBTableDataSetMapping("sqlDBTableDataSetMapping", SqlDBTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDBTableDataSetMapping = new AzureNative.DataShare.SqlDBTableDataSetMapping("sqlDBTableDataSetMapping", new()
 *     {
 *         AccountName = "consumerAccount",
 *         DataSetMappingName = "datasetMappingName1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewSqlDBTableDataSetMapping(ctx, "sqlDBTableDataSetMapping", &datashare.SqlDBTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("consumerAccount"),
 * 			DataSetMappingName:    pulumi.String("datasetMappingName1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.SqlDBTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.SqlDBTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDBTableDataSetMapping = new SqlDBTableDataSetMapping("sqlDBTableDataSetMapping", SqlDBTableDataSetMappingArgs.builder()
 *             .accountName("consumerAccount")
 *             .dataSetMappingName("datasetMappingName1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:SqlDBTableDataSetMapping datasetMappingName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/dataSetMappings/{dataSetMappingName}
 * ```
 */
public class SqlDBTableDataSetMapping internal constructor(
    override val javaResource: com.pulumi.azurenative.datashare.SqlDBTableDataSetMapping,
) : KotlinCustomResource(javaResource, SqlDBTableDataSetMappingMapper) {
    /**
     * The id of the source data set.
     */
    public val dataSetId: Output<String>
        get() = javaResource.dataSetId().applyValue({ args0 -> args0 })

    /**
     * Gets the status of the data set mapping.
     */
    public val dataSetMappingStatus: Output<String>
        get() = javaResource.dataSetMappingStatus().applyValue({ args0 -> args0 })

    /**
     * DatabaseName name of the sink data set
     */
    public val databaseName: Output<String>
        get() = javaResource.databaseName().applyValue({ args0 -> args0 })

    /**
     * Kind of data set mapping.
     * Expected value is 'SqlDBTable'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Name of the azure resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the data set mapping.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Schema of the table. Default value is dbo.
     */
    public val schemaName: Output<String>
        get() = javaResource.schemaName().applyValue({ args0 -> args0 })

    /**
     * Resource id of SQL server
     */
    public val sqlServerResourceId: Output<String>
        get() = javaResource.sqlServerResourceId().applyValue({ args0 -> args0 })

    /**
     * System Data of the Azure resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * SQL DB table name.
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })

    /**
     * Type of the azure resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlDBTableDataSetMappingMapper : ResourceMapper<SqlDBTableDataSetMapping> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datashare.SqlDBTableDataSetMapping::class == javaResource::class

    override fun map(javaResource: Resource): SqlDBTableDataSetMapping =
        SqlDBTableDataSetMapping(
            javaResource as
                com.pulumi.azurenative.datashare.SqlDBTableDataSetMapping,
        )
}

/**
 * @see [SqlDBTableDataSetMapping].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlDBTableDataSetMapping].
 */
public suspend fun sqlDBTableDataSetMapping(
    name: String,
    block: suspend SqlDBTableDataSetMappingResourceBuilder.() -> Unit,
): SqlDBTableDataSetMapping {
    val builder = SqlDBTableDataSetMappingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlDBTableDataSetMapping].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlDBTableDataSetMapping(name: String): SqlDBTableDataSetMapping {
    val builder = SqlDBTableDataSetMappingResourceBuilder()
    builder.name(name)
    return builder.build()
}
