@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * File output type
 */
public enum class OutputType(
    public val javaValue: com.pulumi.azurenative.datashare.enums.OutputType,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.enums.OutputType> {
    Csv(com.pulumi.azurenative.datashare.enums.OutputType.Csv),
    Parquet(com.pulumi.azurenative.datashare.enums.OutputType.Parquet),
    ;

    override fun toJava(): com.pulumi.azurenative.datashare.enums.OutputType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.enums.OutputType): OutputType =
            OutputType.values().first { it.javaValue == javaType }
    }
}
