@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.GetADLSGen2FolderDataSetMappingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the share account.
 * @property dataSetMappingName The name of the dataSetMapping.
 * @property resourceGroupName The resource group name.
 * @property shareSubscriptionName The name of the shareSubscription.
 */
public data class GetADLSGen2FolderDataSetMappingPlainArgs(
    public val accountName: String,
    public val dataSetMappingName: String,
    public val resourceGroupName: String,
    public val shareSubscriptionName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.GetADLSGen2FolderDataSetMappingPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datashare.inputs.GetADLSGen2FolderDataSetMappingPlainArgs =
        com.pulumi.azurenative.datashare.inputs.GetADLSGen2FolderDataSetMappingPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .dataSetMappingName(dataSetMappingName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .shareSubscriptionName(shareSubscriptionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetADLSGen2FolderDataSetMappingPlainArgs].
 */
@PulumiTagMarker
public class GetADLSGen2FolderDataSetMappingPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var dataSetMappingName: String? = null

    private var resourceGroupName: String? = null

    private var shareSubscriptionName: String? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("kxxrbryyiuthblls")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the dataSetMapping.
     */
    @JvmName("wiqwvcvndlyngxit")
    public suspend fun dataSetMappingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataSetMappingName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("jnedhygfxqufysib")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the shareSubscription.
     */
    @JvmName("ovvwjaircafxnxuq")
    public suspend fun shareSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareSubscriptionName = mapped
    }

    internal fun build(): GetADLSGen2FolderDataSetMappingPlainArgs =
        GetADLSGen2FolderDataSetMappingPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            dataSetMappingName = dataSetMappingName ?: throw PulumiNullFieldException("dataSetMappingName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            shareSubscriptionName = shareSubscriptionName ?: throw
                PulumiNullFieldException("shareSubscriptionName"),
        )
}
