@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.GetSqlDBTableDataSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the share account.
 * @property dataSetName The name of the dataSet.
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share.
 */
public data class GetSqlDBTableDataSetPlainArgs(
    public val accountName: String,
    public val dataSetName: String,
    public val resourceGroupName: String,
    public val shareName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.GetSqlDBTableDataSetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.inputs.GetSqlDBTableDataSetPlainArgs =
        com.pulumi.azurenative.datashare.inputs.GetSqlDBTableDataSetPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .dataSetName(dataSetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .shareName(shareName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlDBTableDataSetPlainArgs].
 */
@PulumiTagMarker
public class GetSqlDBTableDataSetPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var dataSetName: String? = null

    private var resourceGroupName: String? = null

    private var shareName: String? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("tcxmtsvfquwycdrl")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("eyishkwpqkmqwtla")
    public suspend fun dataSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataSetName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("psvkmnugkpfafqqr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share.
     */
    @JvmName("tshhkjklgujfugtc")
    public suspend fun shareName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareName = mapped
    }

    internal fun build(): GetSqlDBTableDataSetPlainArgs = GetSqlDBTableDataSetPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        dataSetName = dataSetName ?: throw PulumiNullFieldException("dataSetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        shareName = shareName ?: throw PulumiNullFieldException("shareName"),
    )
}
