@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.ListShareSubscriptionSynchronizationDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the share account.
 * @property filter Filters the results using OData syntax.
 * @property orderby Sorts the results using OData syntax.
 * @property resourceGroupName The resource group name.
 * @property shareSubscriptionName The name of the share subscription.
 * @property skipToken Continuation token
 * @property synchronizationId Synchronization id
 */
public data class ListShareSubscriptionSynchronizationDetailsPlainArgs(
    public val accountName: String,
    public val filter: String? = null,
    public val orderby: String? = null,
    public val resourceGroupName: String,
    public val shareSubscriptionName: String,
    public val skipToken: String? = null,
    public val synchronizationId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.ListShareSubscriptionSynchronizationDetailsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datashare.inputs.ListShareSubscriptionSynchronizationDetailsPlainArgs =
        com.pulumi.azurenative.datashare.inputs.ListShareSubscriptionSynchronizationDetailsPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .filter(filter?.let({ args0 -> args0 }))
            .orderby(orderby?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .shareSubscriptionName(shareSubscriptionName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 }))
            .synchronizationId(synchronizationId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListShareSubscriptionSynchronizationDetailsPlainArgs].
 */
@PulumiTagMarker
public class ListShareSubscriptionSynchronizationDetailsPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var filter: String? = null

    private var orderby: String? = null

    private var resourceGroupName: String? = null

    private var shareSubscriptionName: String? = null

    private var skipToken: String? = null

    private var synchronizationId: String? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("skncexectktkiqcu")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Filters the results using OData syntax.
     */
    @JvmName("hngyblttbewpaart")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filter = mapped
    }

    /**
     * @param value Sorts the results using OData syntax.
     */
    @JvmName("xtjvqivdnbocqwdc")
    public suspend fun orderby(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderby = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("bfintakbbvqknxic")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share subscription.
     */
    @JvmName("cxkqmagcocyrjcbi")
    public suspend fun shareSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareSubscriptionName = mapped
    }

    /**
     * @param value Continuation token
     */
    @JvmName("jiqerlbyifwabpci")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    /**
     * @param value Synchronization id
     */
    @JvmName("tawkmwbptnslhcby")
    public suspend fun synchronizationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.synchronizationId = mapped
    }

    internal fun build(): ListShareSubscriptionSynchronizationDetailsPlainArgs =
        ListShareSubscriptionSynchronizationDetailsPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            filter = filter,
            orderby = orderby,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            shareSubscriptionName = shareSubscriptionName ?: throw
                PulumiNullFieldException("shareSubscriptionName"),
            skipToken = skipToken,
            synchronizationId = synchronizationId ?: throw PulumiNullFieldException("synchronizationId"),
        )
}
