@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.ListShareSubscriptionSynchronizationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the share account.
 * @property filter Filters the results using OData syntax.
 * @property orderby Sorts the results using OData syntax.
 * @property resourceGroupName The resource group name.
 * @property shareSubscriptionName The name of the share subscription.
 * @property skipToken Continuation token
 */
public data class ListShareSubscriptionSynchronizationsPlainArgs(
    public val accountName: String,
    public val filter: String? = null,
    public val orderby: String? = null,
    public val resourceGroupName: String,
    public val shareSubscriptionName: String,
    public val skipToken: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.ListShareSubscriptionSynchronizationsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datashare.inputs.ListShareSubscriptionSynchronizationsPlainArgs =
        com.pulumi.azurenative.datashare.inputs.ListShareSubscriptionSynchronizationsPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .filter(filter?.let({ args0 -> args0 }))
            .orderby(orderby?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .shareSubscriptionName(shareSubscriptionName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListShareSubscriptionSynchronizationsPlainArgs].
 */
@PulumiTagMarker
public class ListShareSubscriptionSynchronizationsPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var filter: String? = null

    private var orderby: String? = null

    private var resourceGroupName: String? = null

    private var shareSubscriptionName: String? = null

    private var skipToken: String? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("kcyedraooetrhnxx")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Filters the results using OData syntax.
     */
    @JvmName("ufdwarmrdpcrcnor")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filter = mapped
    }

    /**
     * @param value Sorts the results using OData syntax.
     */
    @JvmName("flttjilcvjvmhyxc")
    public suspend fun orderby(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderby = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("msxmfmwqtalmnaxu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share subscription.
     */
    @JvmName("cpbqowevnvneqjtg")
    public suspend fun shareSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareSubscriptionName = mapped
    }

    /**
     * @param value Continuation token
     */
    @JvmName("uktnisjnpeojystf")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    internal fun build(): ListShareSubscriptionSynchronizationsPlainArgs =
        ListShareSubscriptionSynchronizationsPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            filter = filter,
            orderby = orderby,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            shareSubscriptionName = shareSubscriptionName ?: throw
                PulumiNullFieldException("shareSubscriptionName"),
            skipToken = skipToken,
        )
}
