@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.ListShareSynchronizationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the share account.
 * @property filter Filters the results using OData syntax.
 * @property orderby Sorts the results using OData syntax.
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share.
 * @property skipToken Continuation token
 */
public data class ListShareSynchronizationsPlainArgs(
    public val accountName: String,
    public val filter: String? = null,
    public val orderby: String? = null,
    public val resourceGroupName: String,
    public val shareName: String,
    public val skipToken: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.ListShareSynchronizationsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.inputs.ListShareSynchronizationsPlainArgs =
        com.pulumi.azurenative.datashare.inputs.ListShareSynchronizationsPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .filter(filter?.let({ args0 -> args0 }))
            .orderby(orderby?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .shareName(shareName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListShareSynchronizationsPlainArgs].
 */
@PulumiTagMarker
public class ListShareSynchronizationsPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var filter: String? = null

    private var orderby: String? = null

    private var resourceGroupName: String? = null

    private var shareName: String? = null

    private var skipToken: String? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("ftpyerpcatqxhsag")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Filters the results using OData syntax.
     */
    @JvmName("vttatewqhkduwlyf")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filter = mapped
    }

    /**
     * @param value Sorts the results using OData syntax.
     */
    @JvmName("ywxixlaibwcfixxn")
    public suspend fun orderby(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderby = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("xkikfoellvnyekqg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share.
     */
    @JvmName("uljxkhhxighxobai")
    public suspend fun shareName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareName = mapped
    }

    /**
     * @param value Continuation token
     */
    @JvmName("kvhtehnmdicborue")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    internal fun build(): ListShareSynchronizationsPlainArgs = ListShareSynchronizationsPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        filter = filter,
        orderby = orderby,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        shareName = shareName ?: throw PulumiNullFieldException("shareName"),
        skipToken = skipToken,
    )
}
