@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.inputs

import com.pulumi.azurenative.datashare.inputs.TableLevelSharingPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Table level sharing properties dto for kusto data set properties
 * @property externalTablesToExclude External tables to be excluded in the data set
 * @property externalTablesToInclude External tables to be included in the data set
 * @property materializedViewsToExclude Materialized views to be excluded in the data set
 * @property materializedViewsToInclude Materialized views to be included in the data set
 * @property tablesToExclude Tables to be excluded in the data set
 * @property tablesToInclude Tables to be included in the data set
 */
public data class TableLevelSharingPropertiesArgs(
    public val externalTablesToExclude: Output<List<String>>? = null,
    public val externalTablesToInclude: Output<List<String>>? = null,
    public val materializedViewsToExclude: Output<List<String>>? = null,
    public val materializedViewsToInclude: Output<List<String>>? = null,
    public val tablesToExclude: Output<List<String>>? = null,
    public val tablesToInclude: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.inputs.TableLevelSharingPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.inputs.TableLevelSharingPropertiesArgs =
        com.pulumi.azurenative.datashare.inputs.TableLevelSharingPropertiesArgs.builder()
            .externalTablesToExclude(
                externalTablesToExclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .externalTablesToInclude(
                externalTablesToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .materializedViewsToExclude(
                materializedViewsToExclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .materializedViewsToInclude(
                materializedViewsToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .tablesToExclude(tablesToExclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tablesToInclude(tablesToInclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [TableLevelSharingPropertiesArgs].
 */
@PulumiTagMarker
public class TableLevelSharingPropertiesArgsBuilder internal constructor() {
    private var externalTablesToExclude: Output<List<String>>? = null

    private var externalTablesToInclude: Output<List<String>>? = null

    private var materializedViewsToExclude: Output<List<String>>? = null

    private var materializedViewsToInclude: Output<List<String>>? = null

    private var tablesToExclude: Output<List<String>>? = null

    private var tablesToInclude: Output<List<String>>? = null

    /**
     * @param value External tables to be excluded in the data set
     */
    @JvmName("rubidjjofsdkaasn")
    public suspend fun externalTablesToExclude(`value`: Output<List<String>>) {
        this.externalTablesToExclude = value
    }

    @JvmName("bvfigahpcybgpdnq")
    public suspend fun externalTablesToExclude(vararg values: Output<String>) {
        this.externalTablesToExclude = Output.all(values.asList())
    }

    /**
     * @param values External tables to be excluded in the data set
     */
    @JvmName("jgfuuajenxdxtfcb")
    public suspend fun externalTablesToExclude(values: List<Output<String>>) {
        this.externalTablesToExclude = Output.all(values)
    }

    /**
     * @param value External tables to be included in the data set
     */
    @JvmName("dcjlewexluvokhmn")
    public suspend fun externalTablesToInclude(`value`: Output<List<String>>) {
        this.externalTablesToInclude = value
    }

    @JvmName("uhssrmtpghbtcygu")
    public suspend fun externalTablesToInclude(vararg values: Output<String>) {
        this.externalTablesToInclude = Output.all(values.asList())
    }

    /**
     * @param values External tables to be included in the data set
     */
    @JvmName("pfqacipliuddbejp")
    public suspend fun externalTablesToInclude(values: List<Output<String>>) {
        this.externalTablesToInclude = Output.all(values)
    }

    /**
     * @param value Materialized views to be excluded in the data set
     */
    @JvmName("yxbyshqheqsbvuhp")
    public suspend fun materializedViewsToExclude(`value`: Output<List<String>>) {
        this.materializedViewsToExclude = value
    }

    @JvmName("fuvhqdcfgaqnrdaf")
    public suspend fun materializedViewsToExclude(vararg values: Output<String>) {
        this.materializedViewsToExclude = Output.all(values.asList())
    }

    /**
     * @param values Materialized views to be excluded in the data set
     */
    @JvmName("ecqukgpvgijfxmpc")
    public suspend fun materializedViewsToExclude(values: List<Output<String>>) {
        this.materializedViewsToExclude = Output.all(values)
    }

    /**
     * @param value Materialized views to be included in the data set
     */
    @JvmName("remgqfvxcommyony")
    public suspend fun materializedViewsToInclude(`value`: Output<List<String>>) {
        this.materializedViewsToInclude = value
    }

    @JvmName("wqljpjvsxdpdlfhb")
    public suspend fun materializedViewsToInclude(vararg values: Output<String>) {
        this.materializedViewsToInclude = Output.all(values.asList())
    }

    /**
     * @param values Materialized views to be included in the data set
     */
    @JvmName("bncusphajmenfxjs")
    public suspend fun materializedViewsToInclude(values: List<Output<String>>) {
        this.materializedViewsToInclude = Output.all(values)
    }

    /**
     * @param value Tables to be excluded in the data set
     */
    @JvmName("hjyhetilfkgaqmlb")
    public suspend fun tablesToExclude(`value`: Output<List<String>>) {
        this.tablesToExclude = value
    }

    @JvmName("crdbtmbmghxwmdyi")
    public suspend fun tablesToExclude(vararg values: Output<String>) {
        this.tablesToExclude = Output.all(values.asList())
    }

    /**
     * @param values Tables to be excluded in the data set
     */
    @JvmName("lttgdexsxasjloki")
    public suspend fun tablesToExclude(values: List<Output<String>>) {
        this.tablesToExclude = Output.all(values)
    }

    /**
     * @param value Tables to be included in the data set
     */
    @JvmName("tgkbkifmuubeqacq")
    public suspend fun tablesToInclude(`value`: Output<List<String>>) {
        this.tablesToInclude = value
    }

    @JvmName("bqnllgrrjhobnpjx")
    public suspend fun tablesToInclude(vararg values: Output<String>) {
        this.tablesToInclude = Output.all(values.asList())
    }

    /**
     * @param values Tables to be included in the data set
     */
    @JvmName("hufkyymyfdipgkue")
    public suspend fun tablesToInclude(values: List<Output<String>>) {
        this.tablesToInclude = Output.all(values)
    }

    /**
     * @param value External tables to be excluded in the data set
     */
    @JvmName("sscausarhpjmhkob")
    public suspend fun externalTablesToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalTablesToExclude = mapped
    }

    /**
     * @param values External tables to be excluded in the data set
     */
    @JvmName("jjioolmtjbopocir")
    public suspend fun externalTablesToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalTablesToExclude = mapped
    }

    /**
     * @param value External tables to be included in the data set
     */
    @JvmName("wnatwxcsuhwqtakj")
    public suspend fun externalTablesToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalTablesToInclude = mapped
    }

    /**
     * @param values External tables to be included in the data set
     */
    @JvmName("piisekimonapwcks")
    public suspend fun externalTablesToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalTablesToInclude = mapped
    }

    /**
     * @param value Materialized views to be excluded in the data set
     */
    @JvmName("cfgnwphgkpsgspkl")
    public suspend fun materializedViewsToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.materializedViewsToExclude = mapped
    }

    /**
     * @param values Materialized views to be excluded in the data set
     */
    @JvmName("joytrnpcklfgvfqu")
    public suspend fun materializedViewsToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.materializedViewsToExclude = mapped
    }

    /**
     * @param value Materialized views to be included in the data set
     */
    @JvmName("htdxvkntqrodtvkj")
    public suspend fun materializedViewsToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.materializedViewsToInclude = mapped
    }

    /**
     * @param values Materialized views to be included in the data set
     */
    @JvmName("wxtujrituexivqtu")
    public suspend fun materializedViewsToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.materializedViewsToInclude = mapped
    }

    /**
     * @param value Tables to be excluded in the data set
     */
    @JvmName("doedxmayarftuxjg")
    public suspend fun tablesToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tablesToExclude = mapped
    }

    /**
     * @param values Tables to be excluded in the data set
     */
    @JvmName("unufavqddgwlwgoa")
    public suspend fun tablesToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tablesToExclude = mapped
    }

    /**
     * @param value Tables to be included in the data set
     */
    @JvmName("prclxewgueokdqme")
    public suspend fun tablesToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tablesToInclude = mapped
    }

    /**
     * @param values Tables to be included in the data set
     */
    @JvmName("ylxngmlclnrkaevh")
    public suspend fun tablesToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tablesToInclude = mapped
    }

    internal fun build(): TableLevelSharingPropertiesArgs = TableLevelSharingPropertiesArgs(
        externalTablesToExclude = externalTablesToExclude,
        externalTablesToInclude = externalTablesToInclude,
        materializedViewsToExclude = materializedViewsToExclude,
        materializedViewsToInclude = materializedViewsToInclude,
        tablesToExclude = tablesToExclude,
        tablesToInclude = tablesToInclude,
    )
}
