@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A type of synchronization setting based on schedule
 * @property kind Kind of synchronization setting on share.
 * Expected value is 'ScheduleBased'.
 * @property recurrenceInterval Recurrence Interval
 * @property synchronizationTime Synchronization time
 */
public data class ScheduledSourceSynchronizationSettingResponse(
    public val kind: String,
    public val recurrenceInterval: String? = null,
    public val synchronizationTime: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.ScheduledSourceSynchronizationSettingResponse):
            ScheduledSourceSynchronizationSettingResponse =
            ScheduledSourceSynchronizationSettingResponse(
                kind = javaType.kind(),
                recurrenceInterval = javaType.recurrenceInterval().map({ args0 -> args0 }).orElse(null),
                synchronizationTime = javaType.synchronizationTime().map({ args0 -> args0 }).orElse(null),
            )
    }
}
