@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.inputs

import com.pulumi.azurenative.dbformariadb.inputs.StorageProfileArgs.builder
import com.pulumi.azurenative.dbformariadb.kotlin.enums.GeoRedundantBackup
import com.pulumi.azurenative.dbformariadb.kotlin.enums.StorageAutogrow
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Storage Profile properties of a server
 * @property backupRetentionDays Backup retention days for the server.
 * @property geoRedundantBackup Enable Geo-redundant or not for server backup.
 * @property storageAutogrow Enable Storage Auto Grow.
 * @property storageMB Max storage allowed for a server.
 */
public data class StorageProfileArgs(
    public val backupRetentionDays: Output<Int>? = null,
    public val geoRedundantBackup: Output<Either<String, GeoRedundantBackup>>? = null,
    public val storageAutogrow: Output<Either<String, StorageAutogrow>>? = null,
    public val storageMB: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformariadb.inputs.StorageProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformariadb.inputs.StorageProfileArgs =
        com.pulumi.azurenative.dbformariadb.inputs.StorageProfileArgs.builder()
            .backupRetentionDays(backupRetentionDays?.applyValue({ args0 -> args0 }))
            .geoRedundantBackup(
                geoRedundantBackup?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .storageAutogrow(
                storageAutogrow?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .storageMB(storageMB?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageProfileArgs].
 */
@PulumiTagMarker
public class StorageProfileArgsBuilder internal constructor() {
    private var backupRetentionDays: Output<Int>? = null

    private var geoRedundantBackup: Output<Either<String, GeoRedundantBackup>>? = null

    private var storageAutogrow: Output<Either<String, StorageAutogrow>>? = null

    private var storageMB: Output<Int>? = null

    /**
     * @param value Backup retention days for the server.
     */
    @JvmName("pbwuwetlkkrnqest")
    public suspend fun backupRetentionDays(`value`: Output<Int>) {
        this.backupRetentionDays = value
    }

    /**
     * @param value Enable Geo-redundant or not for server backup.
     */
    @JvmName("dprywbedicgfgcfi")
    public suspend fun geoRedundantBackup(`value`: Output<Either<String, GeoRedundantBackup>>) {
        this.geoRedundantBackup = value
    }

    /**
     * @param value Enable Storage Auto Grow.
     */
    @JvmName("jqtcpfxwhertmgpj")
    public suspend fun storageAutogrow(`value`: Output<Either<String, StorageAutogrow>>) {
        this.storageAutogrow = value
    }

    /**
     * @param value Max storage allowed for a server.
     */
    @JvmName("aeocddwhpntokvpj")
    public suspend fun storageMB(`value`: Output<Int>) {
        this.storageMB = value
    }

    /**
     * @param value Backup retention days for the server.
     */
    @JvmName("rmybwcxmowovgdwc")
    public suspend fun backupRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionDays = mapped
    }

    /**
     * @param value Enable Geo-redundant or not for server backup.
     */
    @JvmName("bylkpkqkrujdplwv")
    public suspend fun geoRedundantBackup(`value`: Either<String, GeoRedundantBackup>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoRedundantBackup = mapped
    }

    /**
     * @param value Enable Geo-redundant or not for server backup.
     */
    @JvmName("chqycotquyxcceex")
    public fun geoRedundantBackup(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GeoRedundantBackup>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geoRedundantBackup = mapped
    }

    /**
     * @param value Enable Geo-redundant or not for server backup.
     */
    @JvmName("aleejjqaglrgifwg")
    public fun geoRedundantBackup(`value`: GeoRedundantBackup) {
        val toBeMapped = Either.ofRight<String, GeoRedundantBackup>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geoRedundantBackup = mapped
    }

    /**
     * @param value Enable Storage Auto Grow.
     */
    @JvmName("sxrladdmaiqmhdxg")
    public suspend fun storageAutogrow(`value`: Either<String, StorageAutogrow>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAutogrow = mapped
    }

    /**
     * @param value Enable Storage Auto Grow.
     */
    @JvmName("leaicofpbndxrvhk")
    public fun storageAutogrow(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageAutogrow>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAutogrow = mapped
    }

    /**
     * @param value Enable Storage Auto Grow.
     */
    @JvmName("qwcdheupanwsrbnn")
    public fun storageAutogrow(`value`: StorageAutogrow) {
        val toBeMapped = Either.ofRight<String, StorageAutogrow>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAutogrow = mapped
    }

    /**
     * @param value Max storage allowed for a server.
     */
    @JvmName("ltcjueeiwexhlget")
    public suspend fun storageMB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageMB = mapped
    }

    internal fun build(): StorageProfileArgs = StorageProfileArgs(
        backupRetentionDays = backupRetentionDays,
        geoRedundantBackup = geoRedundantBackup,
        storageAutogrow = storageAutogrow,
        storageMB = storageMB,
    )
}
