@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of a private endpoint connection.
 * @property privateEndpoint Private endpoint which the connection belongs to.
 * @property privateLinkServiceConnectionState Connection state of the private endpoint connection.
 * @property provisioningState State of the private endpoint connection.
 */
public data class ServerPrivateEndpointConnectionPropertiesResponse(
    public val privateEndpoint: PrivateEndpointPropertyResponse? = null,
    public val privateLinkServiceConnectionState:
    ServerPrivateLinkServiceConnectionStatePropertyResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbformariadb.outputs.ServerPrivateEndpointConnectionPropertiesResponse):
            ServerPrivateEndpointConnectionPropertiesResponse =
            ServerPrivateEndpointConnectionPropertiesResponse(
                privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.dbformariadb.kotlin.outputs.PrivateEndpointPropertyResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.dbformariadb.kotlin.outputs.ServerPrivateLinkServiceConnectionStatePropertyResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                provisioningState = javaType.provisioningState(),
            )
    }
}
