@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A private endpoint connection under a server
 * @property id Resource Id of the private endpoint connection.
 * @property properties Private endpoint connection properties
 */
public data class ServerPrivateEndpointConnectionResponse(
    public val id: String,
    public val properties: ServerPrivateEndpointConnectionPropertiesResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbformariadb.outputs.ServerPrivateEndpointConnectionResponse):
            ServerPrivateEndpointConnectionResponse = ServerPrivateEndpointConnectionResponse(
            id = javaType.id(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.dbformariadb.kotlin.outputs.ServerPrivateEndpointConnectionPropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
