@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Billing information related properties of a server.
 * @property capacity The scale up/out capacity, representing server's compute units.
 * @property family The family of hardware.
 * @property name The name of the sku, typically, tier + family + cores, e.g. B_Gen4_1, GP_Gen5_8.
 * @property size The size code, to be interpreted by resource as appropriate.
 * @property tier The tier of the particular SKU, e.g. Basic.
 */
public data class SkuResponse(
    public val capacity: Int? = null,
    public val family: String? = null,
    public val name: String,
    public val size: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbformariadb.outputs.SkuResponse):
            SkuResponse = SkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            family = javaType.family().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
