@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin

import com.pulumi.azurenative.dbformysql.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.dbformysql.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The private endpoint connection resource.
 * Azure REST API version: 2022-09-30-preview. Prior API version in Azure Native 1.x: 2018-06-01.
 * Other available API versions: 2018-06-01-privatepreview, 2023-06-30.
 * ## Example Usage
 * ### Approve or reject a private endpoint connection with a given name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.DBforMySQL.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         PrivateEndpointConnectionName = "private-endpoint-connection-name",
 *         PrivateLinkServiceConnectionState = new AzureNative.DBforMySQL.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Approved by johndoe@contoso.com",
 *             Status = AzureNative.DBforMySQL.PrivateEndpointServiceConnectionStatus.Approved,
 *         },
 *         ResourceGroupName = "Default",
 *         ServerName = "test-svr",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformysql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformysql.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &dbformysql.PrivateEndpointConnectionArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("private-endpoint-connection-name"),
 * 			PrivateLinkServiceConnectionState: &dbformysql.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Approved by johndoe@contoso.com"),
 * 				Status:      pulumi.String(dbformysql.PrivateEndpointServiceConnectionStatusApproved),
 * 			},
 * 			ResourceGroupName: pulumi.String("Default"),
 * 			ServerName:        pulumi.String("test-svr"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformysql.PrivateEndpointConnection;
 * import com.pulumi.azurenative.dbformysql.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.dbformysql.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .privateEndpointConnectionName("private-endpoint-connection-name")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("Approved by johndoe@contoso.com")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("Default")
 *             .serverName("test-svr")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbformysql:PrivateEndpointConnection private-endpoint-connection-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property privateEndpointConnectionName
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 */
public data class PrivateEndpointConnectionArgs(
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformysql.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformysql.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.dbformysql.PrivateEndpointConnectionArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("jethmrgqheaojund")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("uwhlhrhuhfxvssba")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tvwferqmbrmbydtw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("muwuvavrjbbprtsw")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value
     */
    @JvmName("dukilapoptuyfvbt")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("sutsddlkerlbwppw")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("hlpfqpbjategkapa")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jhakatnywkgwixof")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("xepocknvmovirswg")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
    )
}
