@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Network related properties of a server
 * @property mode High availability mode for a server.
 * @property standbyAvailabilityZone Availability zone of the standby server.
 * @property state The state of server high availability.
 */
public data class HighAvailabilityResponse(
    public val mode: String? = null,
    public val standbyAvailabilityZone: String? = null,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbformysql.outputs.HighAvailabilityResponse):
            HighAvailabilityResponse = HighAvailabilityResponse(
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            standbyAvailabilityZone = javaType.standbyAvailabilityZone().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
        )
    }
}
