@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Maintenance window of a server.
 * @property customWindow indicates whether custom window is enabled or disabled
 * @property dayOfWeek day of week for maintenance window
 * @property startHour start hour for maintenance window
 * @property startMinute start minute for maintenance window
 */
public data class MaintenanceWindowResponse(
    public val customWindow: String? = null,
    public val dayOfWeek: Int? = null,
    public val startHour: Int? = null,
    public val startMinute: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbformysql.outputs.MaintenanceWindowResponse):
            MaintenanceWindowResponse = MaintenanceWindowResponse(
            customWindow = javaType.customWindow().map({ args0 -> args0 }).orElse(null),
            dayOfWeek = javaType.dayOfWeek().map({ args0 -> args0 }).orElse(null),
            startHour = javaType.startHour().map({ args0 -> args0 }).orElse(null),
            startMinute = javaType.startMinute().map({ args0 -> args0 }).orElse(null),
        )
    }
}
