@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Administrator].
 */
@PulumiTagMarker
public class AdministratorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AdministratorArgs = AdministratorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AdministratorArgsBuilder.() -> Unit) {
        val builder = AdministratorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Administrator {
        val builtJavaResource =
            com.pulumi.azurenative.dbforpostgresql.Administrator(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Administrator(builtJavaResource)
    }
}

/**
 * Represents an Active Directory administrator.
 * Azure REST API version: 2022-12-01.
 * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Adds an Active DIrectory Administrator for the server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var administrator = new AzureNative.DBforPostgreSQL.Administrator("administrator", new()
 *     {
 *         ObjectId = "oooooooo-oooo-oooo-oooo-oooooooooooo",
 *         PrincipalName = "testuser1@microsoft.com",
 *         PrincipalType = AzureNative.DBforPostgreSQL.PrincipalType.User,
 *         ResourceGroupName = "testrg",
 *         ServerName = "testserver",
 *         TenantId = "tttttttt-tttt-tttt-tttt-tttttttttttt",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewAdministrator(ctx, "administrator", &dbforpostgresql.AdministratorArgs{
 * 			ObjectId:          pulumi.String("oooooooo-oooo-oooo-oooo-oooooooooooo"),
 * 			PrincipalName:     pulumi.String("testuser1@microsoft.com"),
 * 			PrincipalType:     pulumi.String(dbforpostgresql.PrincipalTypeUser),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerName:        pulumi.String("testserver"),
 * 			TenantId:          pulumi.String("tttttttt-tttt-tttt-tttt-tttttttttttt"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Administrator;
 * import com.pulumi.azurenative.dbforpostgresql.AdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var administrator = new Administrator("administrator", AdministratorArgs.builder()
 *             .objectId("oooooooo-oooo-oooo-oooo-oooooooooooo")
 *             .principalName("testuser1@microsoft.com")
 *             .principalType("User")
 *             .resourceGroupName("testrg")
 *             .serverName("testserver")
 *             .tenantId("tttttttt-tttt-tttt-tttt-tttttttttttt")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbforpostgresql:Administrator testuser1@microsoft.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/administrators/{objectId}
 * ```
 */
public class Administrator internal constructor(
    override val javaResource: com.pulumi.azurenative.dbforpostgresql.Administrator,
) : KotlinCustomResource(javaResource, AdministratorMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The objectId of the Active Directory administrator.
     */
    public val objectId: Output<String>?
        get() = javaResource.objectId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Active Directory administrator principal name.
     */
    public val principalName: Output<String>?
        get() = javaResource.principalName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The principal type used to represent the type of Active Directory Administrator.
     */
    public val principalType: Output<String>?
        get() = javaResource.principalType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The tenantId of the Active Directory administrator.
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AdministratorMapper : ResourceMapper<Administrator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dbforpostgresql.Administrator::class == javaResource::class

    override fun map(javaResource: Resource): Administrator = Administrator(
        javaResource as
            com.pulumi.azurenative.dbforpostgresql.Administrator,
    )
}

/**
 * @see [Administrator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Administrator].
 */
public suspend fun administrator(
    name: String,
    block: suspend AdministratorResourceBuilder.() -> Unit,
): Administrator {
    val builder = AdministratorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Administrator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun administrator(name: String): Administrator {
    val builder = AdministratorResourceBuilder()
    builder.name(name)
    return builder.build()
}
