@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.DbforpostgresqlFunctions.getAdministratorPlain
import com.pulumi.azurenative.dbforpostgresql.DbforpostgresqlFunctions.getClusterPlain
import com.pulumi.azurenative.dbforpostgresql.DbforpostgresqlFunctions.getConfigurationPlain
import com.pulumi.azurenative.dbforpostgresql.DbforpostgresqlFunctions.getDatabasePlain
import com.pulumi.azurenative.dbforpostgresql.DbforpostgresqlFunctions.getFirewallRulePlain
import com.pulumi.azurenative.dbforpostgresql.DbforpostgresqlFunctions.getGetPrivateDnsZoneSuffixExecutePlain
import com.pulumi.azurenative.dbforpostgresql.DbforpostgresqlFunctions.getMigrationPlain
import com.pulumi.azurenative.dbforpostgresql.DbforpostgresqlFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.dbforpostgresql.DbforpostgresqlFunctions.getRolePlain
import com.pulumi.azurenative.dbforpostgresql.DbforpostgresqlFunctions.getServerPlain
import com.pulumi.azurenative.dbforpostgresql.DbforpostgresqlFunctions.getVirtualEndpointPlain
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetAdministratorPlainArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetAdministratorPlainArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetConfigurationPlainArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetConfigurationPlainArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetDatabasePlainArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetDatabasePlainArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetFirewallRulePlainArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetFirewallRulePlainArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetMigrationPlainArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetMigrationPlainArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetRolePlainArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetRolePlainArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetServerPlainArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetServerPlainArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetVirtualEndpointPlainArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.GetVirtualEndpointPlainArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetAdministratorResult
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetClusterResult
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetConfigurationResult
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetDatabaseResult
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetFirewallRuleResult
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetGetPrivateDnsZoneSuffixExecuteResult
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetMigrationResult
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetRoleResult
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetServerResult
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetVirtualEndpointResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetAdministratorResult.Companion.toKotlin as getAdministratorResultToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetConfigurationResult.Companion.toKotlin as getConfigurationResultToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetDatabaseResult.Companion.toKotlin as getDatabaseResultToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetFirewallRuleResult.Companion.toKotlin as getFirewallRuleResultToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetGetPrivateDnsZoneSuffixExecuteResult.Companion.toKotlin as getGetPrivateDnsZoneSuffixExecuteResultToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetMigrationResult.Companion.toKotlin as getMigrationResultToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetRoleResult.Companion.toKotlin as getRoleResultToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetServerResult.Companion.toKotlin as getServerResultToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.GetVirtualEndpointResult.Companion.toKotlin as getVirtualEndpointResultToKotlin

public object DbforpostgresqlFunctions {
    /**
     * Gets information about a server.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return Represents an Active Directory administrator.
     */
    public suspend fun getAdministrator(argument: GetAdministratorPlainArgs): GetAdministratorResult =
        getAdministratorResultToKotlin(getAdministratorPlain(argument.toJava()).await())

    /**
     * @see [getAdministrator].
     * @param objectId Guid of the objectId for the administrator.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents an Active Directory administrator.
     */
    public suspend fun getAdministrator(
        objectId: String,
        resourceGroupName: String,
        serverName: String,
    ): GetAdministratorResult {
        val argument = GetAdministratorPlainArgs(
            objectId = objectId,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getAdministratorResultToKotlin(getAdministratorPlain(argument.toJava()).await())
    }

    /**
     * @see [getAdministrator].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbforpostgresql&#46;kotlin&#46;inputs&#46;GetAdministratorPlainArgs].
     * @return Represents an Active Directory administrator.
     */
    public suspend
    fun getAdministrator(argument: suspend GetAdministratorPlainArgsBuilder.() -> Unit):
        GetAdministratorResult {
        val builder = GetAdministratorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAdministratorResultToKotlin(getAdministratorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a cluster such as compute and storage configuration and cluster lifecycle metadata such as cluster creation date and time.
     * Azure REST API version: 2022-11-08.
     * Other available API versions: 2023-03-02-preview.
     * @param argument null
     * @return Represents a cluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents a cluster.
     */
    public suspend fun getCluster(clusterName: String, resourceGroupName: String): GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbforpostgresql&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return Represents a cluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a configuration of server.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2017-12-01, 2023-03-01-preview, 2023-06-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return Represents a Configuration.
     */
    public suspend fun getConfiguration(argument: GetConfigurationPlainArgs): GetConfigurationResult =
        getConfigurationResultToKotlin(getConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getConfiguration].
     * @param configurationName The name of the server configuration.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents a Configuration.
     */
    public suspend fun getConfiguration(
        configurationName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetConfigurationResult {
        val argument = GetConfigurationPlainArgs(
            configurationName = configurationName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getConfigurationResultToKotlin(getConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbforpostgresql&#46;kotlin&#46;inputs&#46;GetConfigurationPlainArgs].
     * @return Represents a Configuration.
     */
    public suspend
    fun getConfiguration(argument: suspend GetConfigurationPlainArgsBuilder.() -> Unit):
        GetConfigurationResult {
        val builder = GetConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationResultToKotlin(getConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a database.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2017-12-01, 2023-03-01-preview, 2023-06-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return Represents a Database.
     */
    public suspend fun getDatabase(argument: GetDatabasePlainArgs): GetDatabaseResult =
        getDatabaseResultToKotlin(getDatabasePlain(argument.toJava()).await())

    /**
     * @see [getDatabase].
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents a Database.
     */
    public suspend fun getDatabase(
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetDatabaseResult {
        val argument = GetDatabasePlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getDatabaseResultToKotlin(getDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbforpostgresql&#46;kotlin&#46;inputs&#46;GetDatabasePlainArgs].
     * @return Represents a Database.
     */
    public suspend fun getDatabase(argument: suspend GetDatabasePlainArgsBuilder.() -> Unit):
        GetDatabaseResult {
        val builder = GetDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseResultToKotlin(getDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * List all the firewall rules in a given server.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2017-12-01, 2020-10-05-privatepreview, 2022-11-08, 2023-03-01-preview, 2023-03-02-preview, 2023-06-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return Represents a server firewall rule.
     */
    public suspend fun getFirewallRule(argument: GetFirewallRulePlainArgs): GetFirewallRuleResult =
        getFirewallRuleResultToKotlin(getFirewallRulePlain(argument.toJava()).await())

    /**
     * @see [getFirewallRule].
     * @param firewallRuleName The name of the server firewall rule.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents a server firewall rule.
     */
    public suspend fun getFirewallRule(
        firewallRuleName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetFirewallRuleResult {
        val argument = GetFirewallRulePlainArgs(
            firewallRuleName = firewallRuleName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getFirewallRuleResultToKotlin(getFirewallRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewallRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbforpostgresql&#46;kotlin&#46;inputs&#46;GetFirewallRulePlainArgs].
     * @return Represents a server firewall rule.
     */
    public suspend fun getFirewallRule(argument: suspend GetFirewallRulePlainArgsBuilder.() -> Unit):
        GetFirewallRuleResult {
        val builder = GetFirewallRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallRuleResultToKotlin(getFirewallRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get private DNS zone suffix in the cloud
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2021-03-31-privatepreview, 2021-06-01, 2022-01-20-preview, 2022-03-08-preview, 2023-03-01-preview, 2023-06-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return Represents a resource name availability.
     */
    public suspend fun getGetPrivateDnsZoneSuffixExecute(): GetGetPrivateDnsZoneSuffixExecuteResult =
        getGetPrivateDnsZoneSuffixExecuteResultToKotlin(getGetPrivateDnsZoneSuffixExecutePlain().await())

    /**
     * Gets details of a migration.
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2021-06-15-privatepreview, 2022-05-01-preview, 2023-06-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return Represents a migration resource.
     */
    public suspend fun getMigration(argument: GetMigrationPlainArgs): GetMigrationResult =
        getMigrationResultToKotlin(getMigrationPlain(argument.toJava()).await())

    /**
     * @see [getMigration].
     * @param migrationName The name of the migration.
     * @param resourceGroupName The resource group name of the target database server.
     * @param subscriptionId The subscription ID of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @return Represents a migration resource.
     */
    public suspend fun getMigration(
        migrationName: String,
        resourceGroupName: String,
        subscriptionId: String? = null,
        targetDbServerName: String,
    ): GetMigrationResult {
        val argument = GetMigrationPlainArgs(
            migrationName = migrationName,
            resourceGroupName = resourceGroupName,
            subscriptionId = subscriptionId,
            targetDbServerName = targetDbServerName,
        )
        return getMigrationResultToKotlin(getMigrationPlain(argument.toJava()).await())
    }

    /**
     * @see [getMigration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbforpostgresql&#46;kotlin&#46;inputs&#46;GetMigrationPlainArgs].
     * @return Represents a migration resource.
     */
    public suspend fun getMigration(argument: suspend GetMigrationPlainArgsBuilder.() -> Unit):
        GetMigrationResult {
        val builder = GetMigrationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMigrationResultToKotlin(getMigrationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets private endpoint connection.
     * Azure REST API version: 2022-11-08.
     * Other available API versions: 2018-06-01-privatepreview, 2023-03-02-preview, 2023-06-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return The private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param clusterName The name of the cluster.
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        clusterName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            clusterName = clusterName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbforpostgresql&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The private endpoint connection resource.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a cluster role.
     * Azure REST API version: 2022-11-08.
     * Other available API versions: 2023-03-02-preview.
     * @param argument null
     * @return Represents a cluster role.
     */
    public suspend fun getRole(argument: GetRolePlainArgs): GetRoleResult =
        getRoleResultToKotlin(getRolePlain(argument.toJava()).await())

    /**
     * @see [getRole].
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param roleName The name of the cluster role.
     * @return Represents a cluster role.
     */
    public suspend fun getRole(
        clusterName: String,
        resourceGroupName: String,
        roleName: String,
    ): GetRoleResult {
        val argument = GetRolePlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
            roleName = roleName,
        )
        return getRoleResultToKotlin(getRolePlain(argument.toJava()).await())
    }

    /**
     * @see [getRole].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbforpostgresql&#46;kotlin&#46;inputs&#46;GetRolePlainArgs].
     * @return Represents a cluster role.
     */
    public suspend fun getRole(argument: suspend GetRolePlainArgsBuilder.() -> Unit): GetRoleResult {
        val builder = GetRolePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRoleResultToKotlin(getRolePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a server.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2017-12-01, 2017-12-01-preview, 2020-02-14-preview, 2021-04-10-privatepreview, 2021-06-15-privatepreview, 2022-03-08-preview, 2023-03-01-preview, 2023-06-01-preview, 2023-12-01-preview.
     * @param argument null
     * @return Represents a server.
     */
    public suspend fun getServer(argument: GetServerPlainArgs): GetServerResult =
        getServerResultToKotlin(getServerPlain(argument.toJava()).await())

    /**
     * @see [getServer].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents a server.
     */
    public suspend fun getServer(resourceGroupName: String, serverName: String): GetServerResult {
        val argument = GetServerPlainArgs(
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getServerResultToKotlin(getServerPlain(argument.toJava()).await())
    }

    /**
     * @see [getServer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbforpostgresql&#46;kotlin&#46;inputs&#46;GetServerPlainArgs].
     * @return Represents a server.
     */
    public suspend fun getServer(argument: suspend GetServerPlainArgsBuilder.() -> Unit):
        GetServerResult {
        val builder = GetServerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerResultToKotlin(getServerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a virtual endpoint.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-12-01-preview.
     * @param argument null
     * @return Represents a virtual endpoint for a server.
     */
    public suspend fun getVirtualEndpoint(argument: GetVirtualEndpointPlainArgs):
        GetVirtualEndpointResult =
        getVirtualEndpointResultToKotlin(getVirtualEndpointPlain(argument.toJava()).await())

    /**
     * @see [getVirtualEndpoint].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @param virtualEndpointName The name of the virtual endpoint.
     * @return Represents a virtual endpoint for a server.
     */
    public suspend fun getVirtualEndpoint(
        resourceGroupName: String,
        serverName: String,
        virtualEndpointName: String,
    ): GetVirtualEndpointResult {
        val argument = GetVirtualEndpointPlainArgs(
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            virtualEndpointName = virtualEndpointName,
        )
        return getVirtualEndpointResultToKotlin(getVirtualEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbforpostgresql&#46;kotlin&#46;inputs&#46;GetVirtualEndpointPlainArgs].
     * @return Represents a virtual endpoint for a server.
     */
    public suspend
    fun getVirtualEndpoint(argument: suspend GetVirtualEndpointPlainArgsBuilder.() -> Unit):
        GetVirtualEndpointResult {
        val builder = GetVirtualEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualEndpointResultToKotlin(getVirtualEndpointPlain(builtArgument.toJava()).await())
    }
}
