@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.RoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a cluster role.
 * Azure REST API version: 2022-11-08.
 * Other available API versions: 2023-03-02-preview.
 * ## Example Usage
 * ### RoleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var role = new AzureNative.DBforPostgreSQL.Role("role", new()
 *     {
 *         ClusterName = "pgtestsvc4",
 *         Password = "password",
 *         ResourceGroupName = "TestGroup",
 *         RoleName = "role1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewRole(ctx, "role", &dbforpostgresql.RoleArgs{
 * 			ClusterName:       pulumi.String("pgtestsvc4"),
 * 			Password:          pulumi.String("password"),
 * 			ResourceGroupName: pulumi.String("TestGroup"),
 * 			RoleName:          pulumi.String("role1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Role;
 * import com.pulumi.azurenative.dbforpostgresql.RoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var role = new Role("role", RoleArgs.builder()
 *             .clusterName("pgtestsvc4")
 *             .password("password")
 *             .resourceGroupName("TestGroup")
 *             .roleName("role1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbforpostgresql:Role role1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/{clusterName}/roles/{roleName}
 * ```
 * @property clusterName The name of the cluster.
 * @property password The password of the cluster role.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property roleName The name of the cluster role.
 */
public data class RoleArgs(
    public val clusterName: Output<String>? = null,
    public val password: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val roleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.RoleArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.RoleArgs =
        com.pulumi.azurenative.dbforpostgresql.RoleArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleArgs].
 */
@PulumiTagMarker
public class RoleArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var password: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var roleName: Output<String>? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("hhceqlwmmbqrkrtq")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The password of the cluster role.
     */
    @JvmName("kqqycjliribaqlsw")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vaxwarrsehfuuuuu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the cluster role.
     */
    @JvmName("onbamdlfmqoheqrc")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("emrrldfpefjhirnw")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The password of the cluster role.
     */
    @JvmName("mwantfmvvguqdtsf")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qkohcfrktnvofija")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the cluster role.
     */
    @JvmName("hyyqjredgdjcysrj")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    internal fun build(): RoleArgs = RoleArgs(
        clusterName = clusterName,
        password = password,
        resourceGroupName = resourceGroupName,
        roleName = roleName,
    )
}
