@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.DataEncryptionArgs.builder
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.ArmServerKeyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data encryption properties of a server
 * @property primaryKeyURI URI for the key for data encryption for primary server.
 * @property primaryUserAssignedIdentityId Resource Id for the User assigned identity to be used for data encryption for primary server.
 * @property type Data encryption type to depict if it is System Managed vs Azure Key vault.
 */
public data class DataEncryptionArgs(
    public val primaryKeyURI: Output<String>? = null,
    public val primaryUserAssignedIdentityId: Output<String>? = null,
    public val type: Output<Either<String, ArmServerKeyType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.DataEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.DataEncryptionArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.DataEncryptionArgs.builder()
            .primaryKeyURI(primaryKeyURI?.applyValue({ args0 -> args0 }))
            .primaryUserAssignedIdentityId(primaryUserAssignedIdentityId?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataEncryptionArgs].
 */
@PulumiTagMarker
public class DataEncryptionArgsBuilder internal constructor() {
    private var primaryKeyURI: Output<String>? = null

    private var primaryUserAssignedIdentityId: Output<String>? = null

    private var type: Output<Either<String, ArmServerKeyType>>? = null

    /**
     * @param value URI for the key for data encryption for primary server.
     */
    @JvmName("sdoxwtsplpxlmdoo")
    public suspend fun primaryKeyURI(`value`: Output<String>) {
        this.primaryKeyURI = value
    }

    /**
     * @param value Resource Id for the User assigned identity to be used for data encryption for primary server.
     */
    @JvmName("nmovwripdcinnkxn")
    public suspend fun primaryUserAssignedIdentityId(`value`: Output<String>) {
        this.primaryUserAssignedIdentityId = value
    }

    /**
     * @param value Data encryption type to depict if it is System Managed vs Azure Key vault.
     */
    @JvmName("xgbknsypthhugqdd")
    public suspend fun type(`value`: Output<Either<String, ArmServerKeyType>>) {
        this.type = value
    }

    /**
     * @param value URI for the key for data encryption for primary server.
     */
    @JvmName("qdsbemgqiwvaxnxu")
    public suspend fun primaryKeyURI(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryKeyURI = mapped
    }

    /**
     * @param value Resource Id for the User assigned identity to be used for data encryption for primary server.
     */
    @JvmName("frusqojgahsayigb")
    public suspend fun primaryUserAssignedIdentityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryUserAssignedIdentityId = mapped
    }

    /**
     * @param value Data encryption type to depict if it is System Managed vs Azure Key vault.
     */
    @JvmName("wlxlgchjnwyfhldw")
    public suspend fun type(`value`: Either<String, ArmServerKeyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Data encryption type to depict if it is System Managed vs Azure Key vault.
     */
    @JvmName("bbreasponcmhjakh")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ArmServerKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Data encryption type to depict if it is System Managed vs Azure Key vault.
     */
    @JvmName("mhxccivwffurrgry")
    public fun type(`value`: ArmServerKeyType) {
        val toBeMapped = Either.ofRight<String, ArmServerKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DataEncryptionArgs = DataEncryptionArgs(
        primaryKeyURI = primaryKeyURI,
        primaryUserAssignedIdentityId = primaryUserAssignedIdentityId,
        type = type,
    )
}
