@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.SkuArgs.builder
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.SkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Sku information related properties of a server.
 * @property name The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
 * @property tier The tier of the particular SKU, e.g. Burstable.
 */
public data class SkuArgs(
    public val name: Output<String>,
    public val tier: Output<Either<String, SkuTier>>,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.SkuArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.SkuArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .tier(
                tier.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var tier: Output<Either<String, SkuTier>>? = null

    /**
     * @param value The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
     */
    @JvmName("bjmojcmkphcmqjxt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The tier of the particular SKU, e.g. Burstable.
     */
    @JvmName("afwuwyuooxrtnnfw")
    public suspend fun tier(`value`: Output<Either<String, SkuTier>>) {
        this.tier = value
    }

    /**
     * @param value The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
     */
    @JvmName("wtykvwxtqsfrbxqv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The tier of the particular SKU, e.g. Burstable.
     */
    @JvmName("gumshapcwayytkvm")
    public suspend fun tier(`value`: Either<String, SkuTier>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The tier of the particular SKU, e.g. Burstable.
     */
    @JvmName("kjqrqyerrfhsgtfp")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The tier of the particular SKU, e.g. Burstable.
     */
    @JvmName("ceraphtwheddxgbm")
    public fun tier(`value`: SkuTier) {
        val toBeMapped = Either.ofRight<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier ?: throw PulumiNullFieldException("tier"),
    )
}
