@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.UserAssignedIdentityArgs.builder
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.IdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Information describing the identities associated with this application.
 * @property type the types of identities associated with this resource; currently restricted to 'None and UserAssigned'
 * @property userAssignedIdentities represents user assigned identities map.
 */
public data class UserAssignedIdentityArgs(
    public val type: Output<Either<String, IdentityType>>,
    public val userAssignedIdentities: Output<Map<String, UserIdentityArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.UserAssignedIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.UserAssignedIdentityArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.UserAssignedIdentityArgs.builder()
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [UserAssignedIdentityArgs].
 */
@PulumiTagMarker
public class UserAssignedIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, IdentityType>>? = null

    private var userAssignedIdentities: Output<Map<String, UserIdentityArgs>>? = null

    /**
     * @param value the types of identities associated with this resource; currently restricted to 'None and UserAssigned'
     */
    @JvmName("lwyrkwnirwjxrmwq")
    public suspend fun type(`value`: Output<Either<String, IdentityType>>) {
        this.type = value
    }

    /**
     * @param value represents user assigned identities map.
     */
    @JvmName("ncyqtsfhqsyaohyr")
    public suspend fun userAssignedIdentities(`value`: Output<Map<String, UserIdentityArgs>>) {
        this.userAssignedIdentities = value
    }

    /**
     * @param value the types of identities associated with this resource; currently restricted to 'None and UserAssigned'
     */
    @JvmName("twxescerchfeqaao")
    public suspend fun type(`value`: Either<String, IdentityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value the types of identities associated with this resource; currently restricted to 'None and UserAssigned'
     */
    @JvmName("gpmpgwitjtjoyhkr")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value the types of identities associated with this resource; currently restricted to 'None and UserAssigned'
     */
    @JvmName("usguyjpbkgggtjns")
    public fun type(`value`: IdentityType) {
        val toBeMapped = Either.ofRight<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value represents user assigned identities map.
     */
    @JvmName("tknbogjfchealsmj")
    public suspend fun userAssignedIdentities(`value`: Map<String, UserIdentityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param argument represents user assigned identities map.
     */
    @JvmName("daotvlwhbvgwilue")
    public suspend fun userAssignedIdentities(
        vararg
        argument: Pair<String, suspend UserIdentityArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                UserIdentityArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values represents user assigned identities map.
     */
    @JvmName("rmnmgjeefpiwarsj")
    public fun userAssignedIdentities(vararg values: Pair<String, UserIdentityArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): UserAssignedIdentityArgs = UserAssignedIdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        userAssignedIdentities = userAssignedIdentities,
    )
}
