@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Data encryption properties of a server
 * @property primaryKeyURI URI for the key for data encryption for primary server.
 * @property primaryUserAssignedIdentityId Resource Id for the User assigned identity to be used for data encryption for primary server.
 * @property type Data encryption type to depict if it is System Managed vs Azure Key vault.
 */
public data class DataEncryptionResponse(
    public val primaryKeyURI: String? = null,
    public val primaryUserAssignedIdentityId: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.DataEncryptionResponse):
            DataEncryptionResponse = DataEncryptionResponse(
            primaryKeyURI = javaType.primaryKeyURI().map({ args0 -> args0 }).orElse(null),
            primaryUserAssignedIdentityId = javaType.primaryUserAssignedIdentityId().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
