@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * High availability properties of a server
 * @property mode The HA mode for the server.
 * @property standbyAvailabilityZone availability zone information of the standby.
 * @property state A state of a HA server that is visible to user.
 */
public data class HighAvailabilityResponse(
    public val mode: String? = null,
    public val standbyAvailabilityZone: String? = null,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.HighAvailabilityResponse):
            HighAvailabilityResponse = HighAvailabilityResponse(
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            standbyAvailabilityZone = javaType.standbyAvailabilityZone().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
        )
    }
}
