@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Migration status.
 * @property currentSubStateDetails Current Migration sub state details.
 * @property error Error message, if any, for the migration state
 * @property state State of migration
 */
public data class MigrationStatusResponse(
    public val currentSubStateDetails: MigrationSubStateDetailsResponse,
    public val error: String,
    public val state: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.MigrationStatusResponse):
            MigrationStatusResponse = MigrationStatusResponse(
            currentSubStateDetails = javaType.currentSubStateDetails().let({ args0 ->
                com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.MigrationSubStateDetailsResponse.Companion.toKotlin(args0)
            }),
            error = javaType.error(),
            state = javaType.state(),
        )
    }
}
