@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin

import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.ControllerDetailsResponse
import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.SubnetDetailsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.ControllerDetailsResponse.Companion.toKotlin as controllerDetailsResponseToKotlin
import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.SubnetDetailsResponse.Companion.toKotlin as subnetDetailsResponseToKotlin

/**
 * Builder for [DelegatedSubnetServiceDetails].
 */
@PulumiTagMarker
public class DelegatedSubnetServiceDetailsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DelegatedSubnetServiceDetailsArgs = DelegatedSubnetServiceDetailsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DelegatedSubnetServiceDetailsArgsBuilder.() -> Unit) {
        val builder = DelegatedSubnetServiceDetailsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DelegatedSubnetServiceDetails {
        val builtJavaResource =
            com.pulumi.azurenative.delegatednetwork.DelegatedSubnetServiceDetails(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DelegatedSubnetServiceDetails(builtJavaResource)
    }
}

/**
 * Represents an instance of a orchestrator.
 * Azure REST API version: 2021-03-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2023-05-18-preview, 2023-06-27-preview.
 * ## Example Usage
 * ### put delegated subnet
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var delegatedSubnetServiceDetails = new AzureNative.DelegatedNetwork.DelegatedSubnetServiceDetails("delegatedSubnetServiceDetails", new()
 *     {
 *         ControllerDetails = new AzureNative.DelegatedNetwork.Inputs.ControllerDetailsArgs
 *         {
 *             Id = "/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/dnctestcontroller",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "TestRG",
 *         ResourceName = "delegated1",
 *         SubnetDetails = new AzureNative.DelegatedNetwork.Inputs.SubnetDetailsArgs
 *         {
 *             Id = "/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/delegatednetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := delegatednetwork.NewDelegatedSubnetServiceDetails(ctx, "delegatedSubnetServiceDetails", &delegatednetwork.DelegatedSubnetServiceDetailsArgs{
 * 			ControllerDetails: &delegatednetwork.ControllerDetailsTypeArgs{
 * 				Id: pulumi.String("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/dnctestcontroller"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("TestRG"),
 * 			ResourceName:      pulumi.String("delegated1"),
 * 			SubnetDetails: &delegatednetwork.SubnetDetailsArgs{
 * 				Id: pulumi.String("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.delegatednetwork.DelegatedSubnetServiceDetails;
 * import com.pulumi.azurenative.delegatednetwork.DelegatedSubnetServiceDetailsArgs;
 * import com.pulumi.azurenative.delegatednetwork.inputs.ControllerDetailsArgs;
 * import com.pulumi.azurenative.delegatednetwork.inputs.SubnetDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var delegatedSubnetServiceDetails = new DelegatedSubnetServiceDetails("delegatedSubnetServiceDetails", DelegatedSubnetServiceDetailsArgs.builder()
 *             .controllerDetails(ControllerDetailsArgs.builder()
 *                 .id("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/dnctestcontroller")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("TestRG")
 *             .resourceName("delegated1")
 *             .subnetDetails(SubnetDetailsArgs.builder()
 *                 .id("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:delegatednetwork:DelegatedSubnetServiceDetails delegated1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/delegatedSubnets/{resourceName}
 * ```
 */
public class DelegatedSubnetServiceDetails internal constructor(
    override val javaResource: com.pulumi.azurenative.delegatednetwork.DelegatedSubnetServiceDetails,
) : KotlinCustomResource(javaResource, DelegatedSubnetServiceDetailsMapper) {
    /**
     * Properties of the controller.
     */
    public val controllerDetails: Output<ControllerDetailsResponse>?
        get() = javaResource.controllerDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> controllerDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current state of dnc delegated subnet resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource guid.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * subnet details
     */
    public val subnetDetails: Output<SubnetDetailsResponse>?
        get() = javaResource.subnetDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subnetDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DelegatedSubnetServiceDetailsMapper : ResourceMapper<DelegatedSubnetServiceDetails> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.delegatednetwork.DelegatedSubnetServiceDetails::class == javaResource::class

    override fun map(javaResource: Resource): DelegatedSubnetServiceDetails =
        DelegatedSubnetServiceDetails(
            javaResource as
                com.pulumi.azurenative.delegatednetwork.DelegatedSubnetServiceDetails,
        )
}

/**
 * @see [DelegatedSubnetServiceDetails].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DelegatedSubnetServiceDetails].
 */
public suspend fun delegatedSubnetServiceDetails(
    name: String,
    block: suspend DelegatedSubnetServiceDetailsResourceBuilder.() -> Unit,
):
    DelegatedSubnetServiceDetails {
    val builder = DelegatedSubnetServiceDetailsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DelegatedSubnetServiceDetails].
 * @param name The _unique_ name of the resulting resource.
 */
public fun delegatedSubnetServiceDetails(name: String): DelegatedSubnetServiceDetails {
    val builder = DelegatedSubnetServiceDetailsResourceBuilder()
    builder.name(name)
    return builder.build()
}
