@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin

import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.ControllerDetailsResponse
import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.OrchestratorIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.ControllerDetailsResponse.Companion.toKotlin as controllerDetailsResponseToKotlin
import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.OrchestratorIdentityResponse.Companion.toKotlin as orchestratorIdentityResponseToKotlin

/**
 * Builder for [OrchestratorInstanceServiceDetails].
 */
@PulumiTagMarker
public class OrchestratorInstanceServiceDetailsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrchestratorInstanceServiceDetailsArgs = OrchestratorInstanceServiceDetailsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrchestratorInstanceServiceDetailsArgsBuilder.() -> Unit) {
        val builder = OrchestratorInstanceServiceDetailsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OrchestratorInstanceServiceDetails {
        val builtJavaResource =
            com.pulumi.azurenative.delegatednetwork.OrchestratorInstanceServiceDetails(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OrchestratorInstanceServiceDetails(builtJavaResource)
    }
}

/**
 * Represents an instance of a orchestrator.
 * Azure REST API version: 2021-03-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2023-05-18-preview, 2023-06-27-preview.
 * ## Example Usage
 * ### Create orchestrator instance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var orchestratorInstanceServiceDetails = new AzureNative.DelegatedNetwork.OrchestratorInstanceServiceDetails("orchestratorInstanceServiceDetails", new()
 *     {
 *         ApiServerEndpoint = "https://testk8s.cloudapp.net",
 *         ClusterRootCA = "ddsadsad344mfdsfdl",
 *         ControllerDetails = new AzureNative.DelegatedNetwork.Inputs.ControllerDetailsArgs
 *         {
 *             Id = "/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/testcontroller",
 *         },
 *         Identity = new AzureNative.DelegatedNetwork.Inputs.OrchestratorIdentityArgs
 *         {
 *             Type = AzureNative.DelegatedNetwork.ResourceIdentityType.SystemAssigned,
 *         },
 *         Kind = AzureNative.DelegatedNetwork.OrchestratorKind.Kubernetes,
 *         Location = "West US",
 *         OrchestratorAppId = "546192d7-503f-477a-9cfe-4efc3ee2b6e1",
 *         OrchestratorTenantId = "da6192d7-503f-477a-9cfe-4efc3ee2b6c3",
 *         PrivateLinkResourceId = "/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/privateLinkServices/plresource1",
 *         ResourceGroupName = "TestRG",
 *         ResourceName = "testk8s1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/delegatednetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := delegatednetwork.NewOrchestratorInstanceServiceDetails(ctx, "orchestratorInstanceServiceDetails", &delegatednetwork.OrchestratorInstanceServiceDetailsArgs{
 * 			ApiServerEndpoint: pulumi.String("https://testk8s.cloudapp.net"),
 * 			ClusterRootCA:     pulumi.String("ddsadsad344mfdsfdl"),
 * 			ControllerDetails: &delegatednetwork.ControllerDetailsTypeArgs{
 * 				Id: pulumi.String("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/testcontroller"),
 * 			},
 * 			Identity: &delegatednetwork.OrchestratorIdentityArgs{
 * 				Type: delegatednetwork.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Kind:                  pulumi.String(delegatednetwork.OrchestratorKindKubernetes),
 * 			Location:              pulumi.String("West US"),
 * 			OrchestratorAppId:     pulumi.String("546192d7-503f-477a-9cfe-4efc3ee2b6e1"),
 * 			OrchestratorTenantId:  pulumi.String("da6192d7-503f-477a-9cfe-4efc3ee2b6c3"),
 * 			PrivateLinkResourceId: pulumi.String("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/privateLinkServices/plresource1"),
 * 			ResourceGroupName:     pulumi.String("TestRG"),
 * 			ResourceName:          pulumi.String("testk8s1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.delegatednetwork.OrchestratorInstanceServiceDetails;
 * import com.pulumi.azurenative.delegatednetwork.OrchestratorInstanceServiceDetailsArgs;
 * import com.pulumi.azurenative.delegatednetwork.inputs.ControllerDetailsArgs;
 * import com.pulumi.azurenative.delegatednetwork.inputs.OrchestratorIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orchestratorInstanceServiceDetails = new OrchestratorInstanceServiceDetails("orchestratorInstanceServiceDetails", OrchestratorInstanceServiceDetailsArgs.builder()
 *             .apiServerEndpoint("https://testk8s.cloudapp.net")
 *             .clusterRootCA("ddsadsad344mfdsfdl")
 *             .controllerDetails(ControllerDetailsArgs.builder()
 *                 .id("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/testcontroller")
 *                 .build())
 *             .identity(OrchestratorIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .kind("Kubernetes")
 *             .location("West US")
 *             .orchestratorAppId("546192d7-503f-477a-9cfe-4efc3ee2b6e1")
 *             .orchestratorTenantId("da6192d7-503f-477a-9cfe-4efc3ee2b6c3")
 *             .privateLinkResourceId("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/privateLinkServices/plresource1")
 *             .resourceGroupName("TestRG")
 *             .resourceName("testk8s1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:delegatednetwork:OrchestratorInstanceServiceDetails testk8s1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/orchestrators/{resourceName}
 * ```
 */
public class OrchestratorInstanceServiceDetails internal constructor(
    override val javaResource:
    com.pulumi.azurenative.delegatednetwork.OrchestratorInstanceServiceDetails,
) : KotlinCustomResource(javaResource, OrchestratorInstanceServiceDetailsMapper) {
    /**
     * K8s APIServer url. Either one of apiServerEndpoint or privateLinkResourceId can be specified
     */
    public val apiServerEndpoint: Output<String>?
        get() = javaResource.apiServerEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * RootCA certificate of kubernetes cluster base64 encoded
     */
    public val clusterRootCA: Output<String>?
        get() = javaResource.clusterRootCA().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Properties of the controller.
     */
    public val controllerDetails: Output<ControllerDetailsResponse>
        get() = javaResource.controllerDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                controllerDetailsResponseToKotlin(args0)
            })
        })

    /**
     * The identity of the orchestrator
     */
    public val identity: Output<OrchestratorIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    orchestratorIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The kind of workbook. Choices are user and shared.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * AAD ID used with apiserver
     */
    public val orchestratorAppId: Output<String>?
        get() = javaResource.orchestratorAppId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * TenantID of server App ID
     */
    public val orchestratorTenantId: Output<String>?
        get() = javaResource.orchestratorTenantId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * private link arm resource id. Either one of apiServerEndpoint or privateLinkResourceId can be specified
     */
    public val privateLinkResourceId: Output<String>?
        get() = javaResource.privateLinkResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The current state of orchestratorInstance resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource guid.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object OrchestratorInstanceServiceDetailsMapper :
    ResourceMapper<OrchestratorInstanceServiceDetails> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.delegatednetwork.OrchestratorInstanceServiceDetails::class == javaResource::class

    override fun map(javaResource: Resource): OrchestratorInstanceServiceDetails =
        OrchestratorInstanceServiceDetails(
            javaResource as
                com.pulumi.azurenative.delegatednetwork.OrchestratorInstanceServiceDetails,
        )
}

/**
 * @see [OrchestratorInstanceServiceDetails].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrchestratorInstanceServiceDetails].
 */
public suspend fun orchestratorInstanceServiceDetails(
    name: String,
    block: suspend OrchestratorInstanceServiceDetailsResourceBuilder.() -> Unit,
):
    OrchestratorInstanceServiceDetails {
    val builder = OrchestratorInstanceServiceDetailsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrchestratorInstanceServiceDetails].
 * @param name The _unique_ name of the resulting resource.
 */
public fun orchestratorInstanceServiceDetails(name: String): OrchestratorInstanceServiceDetails {
    val builder = OrchestratorInstanceServiceDetailsResourceBuilder()
    builder.name(name)
    return builder.build()
}
